%define apachedir /etc/httpd
%define apacheuser www
%define apachegroup www
%define contentdir /home/httpd

Summary: A bookmark application for use under the horde framework.
Name: trean-h3
Version: 1.0
Release: 0%{?dist}
License: LGPL
Group: Applications/Horde
Source: ftp://ftp.horde.org/pub/trean/tarballs/trean-h3-%{version}.tar.gz   
Vendor: The Horde Project
URL: http://www.horde.org/
BuildArchitectures: noarch
BuildRoot: /tmp/horde-root
AutoReq: no
Requires: horde >= 3.2
Requires: php >= 4.3.0
Requires: httpd >= 2.0.46
Obsoletes: trean
Provides: trean
Prereq: /usr/bin/perl

%description
The Trean (Bookmarks) application allows you to store, organize and manage, 
and most importantly access your web browser bookmarks on-line and in one
central place accessible from any web browser. 

The Horde Project writes web applications in PHP and releases them under
Open Source licenses.  For more information (including help with Horde
and its modules) please visit http://www.horde.org/.

This package contains customizations for SME Server
and will probably not work properly on other Linux systems.

%prep

%setup -q -n %{name}-%{version}

%build

%install
[ "$RPM_BUILD_ROOT" != "/" ] && rm -rf $RPM_BUILD_ROOT
mkdir -p $RPM_BUILD_ROOT%{apachedir}/conf
mkdir -p $RPM_BUILD_ROOT%{contentdir}/html/horde/trean
cp -pR * $RPM_BUILD_ROOT%{contentdir}/html/horde/trean
cd $RPM_BUILD_ROOT%{contentdir}/html/horde/trean/config


for d in *.dist; do
	d0=`basename $d .dist`
	if [ ! -f "$d0" ]; then
		cp -p $d $d0
	fi
done

%clean
[ "$RPM_BUILD_ROOT" != "/" ] && rm -rf $RPM_BUILD_ROOT

%post

%postun

%files
%defattr(-,root,root)
# Include top level with %dir so not all files are sucked in
%dir %{contentdir}/html/horde/trean
# Include top-level files by hand
%{contentdir}/html/horde/trean/*.php
# Include these dirs so that all files _will_ get sucked in
%{contentdir}/html/horde/trean/lib
%{contentdir}/html/horde/trean/locale
%{contentdir}/html/horde/trean/po
%{contentdir}/html/horde/trean/templates
%{contentdir}/html/horde/trean/themes
%{contentdir}/html/horde/trean/scripts
%{contentdir}/html/horde/trean/graphics/
%{contentdir}/html/horde/trean/js
# Mark documentation files with %doc and %docdir
%doc %{contentdir}/html/horde/trean/COPYING
%doc %{contentdir}/html/horde/trean/LICENSE
%doc %{contentdir}/html/horde/trean/README
%docdir %{contentdir}/html/horde/trean/docs
%{contentdir}/html/horde/trean/docs
# Mark configuration files with %config and use secure permissions
# (note that .dist files are considered software; don't mark %config)
%attr(750,root,%{apachegroup}) %dir %{contentdir}/html/horde/trean/config
%defattr(640,root,%{apachegroup})
%{contentdir}/html/horde/trean/config/.htaccess
%{contentdir}/html/horde/trean/config/*.dist
%config %{contentdir}/html/horde/trean/config/*.php
%config %{contentdir}/html/horde/trean/config/*.xml

%changelog
* Sun Jun 22 2008 John H. Bennett III <bennettj@johnbennettservices.com>
* Re-rolled from CVS 6-22-2008 1.0-CVS

* Sun Jun 04 2006 John H. Bennett III <bennettj@johnbennettservices.com>
- [0.0.1-1sme01]
- Initial Release from CVS 2006-06-04

