%define peardir /usr/share/pear
%define xmldir  /var/lib/pear

Summary: PEAR: Horde RPC API
Name: Horde_Rpc
Version: 2.1.9
Release: 1%{?dist}
License: LGPL-2.1
Group: Development/Libraries
Source0: http://pear.horde.org/get/Horde_Rpc-%{version}.tgz
BuildRoot: %{_tmppath}/%{name}-%{version}-root-%(%{__id_u} -n)
URL: http://pear.horde.org/package/Horde_Rpc
BuildRequires:       php-pear(PEAR) >= 1.4.7
BuildRequires: php-channel(pear.horde.org)
Requires: Horde_Role >= 1.0.0
Requires: Horde_Core >= 2.0.0
Requires: Horde_Core < 3.0.0alpha1
Requires: Horde_Exception >= 2.0.0
Requires: Horde_Exception < 3.0.0alpha1
Requires: Horde_Perms >= 2.0.0
Requires: Horde_Perms < 3.0.0alpha1
Requires: Horde_Serialize >= 2.0.0
Requires: Horde_Serialize < 3.0.0alpha1
Requires: Horde_Support >= 2.0.0
Requires: Horde_Support < 3.0.0alpha1
Requires: Horde_Translation >= 2.0.0
Requires: Horde_Translation < 3.0.0alpha1
Requires: Horde_Util >= 2.0.0
Requires: Horde_Util < 3.0.0alpha1
Requires: Horde_Xml_Element >= 2.0.0
Requires: Horde_Xml_Element < 3.0.0alpha1
Requires: php-pear(PEAR) >= 1.7.0
Requires: php-channel(pear.horde.org)
BuildArch: noarch

Provides:       %{name} = %{version}

%description
A common abstracted interface to various remote methods of accessing Horde
functionality.

%prep
%setup -c -T
pear -v -c pearrc \
        -d php_dir=%{peardir} \
        -d doc_dir=%{pear_docdir} \
        -d bin_dir=%{_bindir} \
        -d data_dir=%{peardir}/data \
        -d test_dir=%{peardir}/tests \
        -d ext_dir=%{_libdir} \
        -d horde_dir=%{pear_hordedir} \
        -s

%build

%install
rm -rf %{buildroot}
pear -c pearrc install --nodeps --packagingroot %{buildroot} %{SOURCE0}
        
# Clean up unnecessary files
rm pearrc
rm %{buildroot}/%{peardir}/.filemap
rm %{buildroot}/%{peardir}/.lock
rm -rf %{buildroot}/%{peardir}/.registry
rm -rf %{buildroot}%{peardir}/.channels
rm %{buildroot}%{peardir}/.depdb
rm %{buildroot}%{peardir}/.depdblock

#mv %{buildroot}/docs .


# Install XML package description
mkdir -p %{buildroot}%{xmldir}
tar -xzf %{SOURCE0} package.xml
cp -p package.xml %{buildroot}%{xmldir}/Horde_Rpc.xml

%clean
rm -rf %{buildroot}

%post
pear install --nodeps --soft --force --register-only %{xmldir}/Horde_Rpc.xml >/dev/null || :

%postun
if [ "$1" -eq "0" ]; then
    pear uninstall --nodeps --ignore-errors --register-only pear.horde.org/Horde_Rpc >/dev/null || :
fi

%files
%defattr(-,root,root)
#%doc docs/Horde_Rpc/*
%{peardir}/*
%{xmldir}/Horde_Rpc.xml

%changelog
* Fri Dec 6 2019 John H. Bennett III <bennettj@johnbennettservices.com> - 2.1.9-1
- Updated to 2.1.9

* Sun Nov 12 2017 John H. Bennett III <bennettj@johnbennettservices.com> - 2.1.8-1
- Updated to 2.1.8

* Wed Mar 23 2016 John H. Bennett III <bennettj@johnbennettservices.com> - 2.1.7-1
- Updated to 2.1.7

* Sat Aug 1 2015 John H. Bennett III <bennettj@johnbennettservices.com> - 2.1.6-1
- Updated to 2.1.6

* Sat Aug 1 2015 John H. Bennett III <bennettj@johnbennettservices.com> - 2.1.5-1
- Updated to 2.1.5

* Thu Apr 16 2015 John H. Bennett III <bennettj@johnbennettservices.com> - 2.1.4-1
- Updated to 2.1.4

* Tue Feb 10 2015 John H. Bennett III <bennettj@johnbennettservices.com> - 2.1.3-1
- Updated to 2.1.3

* Sat Jan 10 2015 John H. Bennett III <bennettj@johnbennettservices.com> - 2.1.2-1
- Updated to 2.1.2

* Wed Oct 16 2013 John H. Bennett III <bennettj@johnbennettservices.com> - 2.1.1-1
- Updated to 2.1.1

* Fri Jun 14 2013 John H. Bennett III <bennettj@johnbennettservices.com> - 2.1.0-1
- Updated to 2.1.0

* Tue Jun 4 2013 John H. Bennett III <bennettj@johnbennettservices.com> - 2.0.5-1
- Initial release for SME Server
- Original build from pear make-rpm-spec
