%define peardir %(pear config-get php_dir 2> /dev/null || echo %{_datadir}/pear)
%define xmldir  /var/lib/pear
%global pear_name XML_RPC2

Summary: XML-RPC client/server library
Name: php-pear-XML-RPC2
Version: 1.1.4
Release: 1%{?dist}
License: PHP License 3.02
Group: Development/Libraries
Source0: http://pear.php.net/get/XML_RPC2-%{version}.tgz
BuildRoot: %{_tmppath}/%{name}-%{version}-root-%(%{__id_u} -n)
URL: http://pear.php.net/package/XML_RPC2

BuildRequires:  php-pear(PEAR) >= 1.7.0
Requires: php-pear(HTTP_Request2) >= 0.6.0
Requires: php-pear(Cache_Lite) >= 1.6.0
Requires: php-pear(PEAR) >= 1.5.4

Provides:       php-pear(%{pear_name}) = %{version}

#BuildRequires: PEAR::PEAR >= 1.4.7
#Requires: PEAR::HTTP_Request2 >= 0.6.0
#Requires: PEAR::Cache_Lite >= 1.6.0
#Requires: PEAR::PEAR >= 1.5.4

BuildArch: noarch

%description
XML_RPC2 is a pear package providing XML_RPC client and server services.
XML-RPC is a simple remote procedure call protocol built using HTTP as
transport and XML as encoding.
    As a client library, XML_RPC2 is capable of creating a proxy class
which exposes the methods exported by the server. As a server library,
XML_RPC2 is capable of exposing methods from a class or object instance,
seamlessly exporting local methods as remotely callable procedures.

%prep
%setup -c -T
pear -v -c pearrc \
        -d php_dir=%{peardir} \
        -d doc_dir=/docs \
        -d bin_dir=%{_bindir} \
        -d data_dir=%{peardir}/data \
        -d test_dir=%{peardir}/tests \
        -d ext_dir=%{_libdir} \
        -s

%build

%install
rm -rf %{buildroot}
pear -c pearrc install --nodeps --packagingroot %{buildroot} %{SOURCE0}
        
# Clean up unnecessary files
rm pearrc
rm %{buildroot}/%{peardir}/.filemap
rm %{buildroot}/%{peardir}/.lock
rm -rf %{buildroot}/%{peardir}/.registry
rm -rf %{buildroot}%{peardir}/.channels
rm %{buildroot}%{peardir}/.depdb
rm %{buildroot}%{peardir}/.depdblock

mv %{buildroot}/docs .


# Install XML package description
mkdir -p %{buildroot}%{xmldir}
tar -xzf %{SOURCE0} package.xml
cp -p package.xml %{buildroot}%{xmldir}/XML_RPC2.xml

%clean
rm -rf %{buildroot}

%post
pear install --nodeps --soft --force --register-only %{xmldir}/XML_RPC2.xml >/dev/null || :

%postun
if [ "$1" -eq "0" ]; then
    pear uninstall --nodeps --ignore-errors --register-only pear.php.net/XML_RPC2 >/dev/null || :
fi

%files
%defattr(-,root,root)
%doc docs/XML_RPC2/*
%{peardir}/*
%{xmldir}/XML_RPC2.xml

%changelog
* Sun Aug 20 2018 John H. Bennett III <bennettj@johnbennettservices.com> - 1.1.4-1
- updated to 1.1.4

* Wed Jul 27 2016 John H. Bennett III <bennettj@johnbennettservices.com> - 1.1.3-1
- updated to 1.1.3

* Mon Mar 31 2014 John H. Bennett III <bennettj@johnbennettservices.com> - 1.1.2-1
- updated to 1.1.2

* Mon May 6 2013 John H. Bennett III <bennettj@johnbennettservices.com> - 1.1.1-2
- updated spec file requires section, and left original info remarked.

* Sun May 5 2013 John H. Bennett III <bennettj@johnbennettservices.com> - 1.1.1-1
- Original from pear-make-rpm-spec.

