%define peardir /usr/share/pear
%define xmldir  /var/lib/pear

Summary: PEAR: Horde Shared Permissions System
Name: Horde_Share
Version: 2.2.0
Release: 1%{?dist}
License: LGPL-2.1
Group: Development/Libraries
Source0: http://pear.horde.org/get/Horde_Share-%{version}.tgz
BuildRoot: %{_tmppath}/%{name}-%{version}-root-%(%{__id_u} -n)
URL: http://pear.horde.org/package/Horde_Share
BuildRequires:       php-pear(PEAR) >= 1.4.7
BuildRequires: php-channel(pear.horde.org)
Requires: Horde_Role >= 1.0.0
Requires: Horde_Db >= 2.0.0
Requires: Horde_Db < 3.0.0alpha1
Requires: Horde_Exception >= 2.0.0
Requires: Horde_Exception < 3.0.0alpha1
Requires: Horde_Group >= 2.0.0
Requires: Horde_Group < 3.0.0alpha1
Requires: Horde_Perms >= 2.1.0
Requires: Horde_Perms < 3.0.0alpha1
Requires: Horde_Support >= 2.0.0
Requires: Horde_Support < 3.0.0alpha1
Requires: Horde_Translation >= 2.0.0
Requires: Horde_Translation < 3.0.0alpha1
Requires: Horde_Url >= 2.0.0
Requires: Horde_Url < 3.0.0alpha1
Requires: Horde_Util >= 2.0.0
Requires: Horde_Util < 3.0.0alpha1
Requires: php-pear(PEAR) >= 1.7.0
Requires: php-channel(pear.horde.org)
BuildArch: noarch

Provides:       %{name} = %{version}

%description
Horde_Share provides an interface to all shared resources a user
owns or has access to.

%prep
%setup -c -T
pear -v -c pearrc \
        -d php_dir=%{peardir} \
        -d doc_dir=%{pear_docdir} \
        -d bin_dir=%{_bindir} \
        -d data_dir=%{peardir}/data \
        -d test_dir=%{peardir}/tests \
        -d ext_dir=%{_libdir} \
        -d horde_dir=%{pear_hordedir} \
        -s

%build

%install
rm -rf %{buildroot}
pear -c pearrc install --nodeps --packagingroot %{buildroot} %{SOURCE0}
        
# Clean up unnecessary files
rm pearrc
rm %{buildroot}/%{peardir}/.filemap
rm %{buildroot}/%{peardir}/.lock
rm -rf %{buildroot}/%{peardir}/.registry
rm -rf %{buildroot}%{peardir}/.channels
rm %{buildroot}%{peardir}/.depdb
rm %{buildroot}%{peardir}/.depdblock

#mv %{buildroot}/docs .


# Install XML package description
mkdir -p %{buildroot}%{xmldir}
tar -xzf %{SOURCE0} package.xml
cp -p package.xml %{buildroot}%{xmldir}/Horde_Share.xml

%clean
rm -rf %{buildroot}

%post
pear install --nodeps --soft --force --register-only %{xmldir}/Horde_Share.xml >/dev/null || :

%postun
if [ "$1" -eq "0" ]; then
    pear uninstall --nodeps --ignore-errors --register-only pear.horde.org/Horde_Share >/dev/null || :
fi

%files
%defattr(-,root,root)
#%doc docs/Horde_Share/*
%{peardir}/*
%{xmldir}/Horde_Share.xml

%changelog
* Sun Nov 12 2017 John H. Bennett III <bennettj@johnbennettservices.com> - 2.2.0-1
- Updated to 2.2.0

* Sat Mar 4 2017 John H. Bennett III <bennettj@johnbennettservices.com> - 2.1.2-1
- Updated to 2.1.2

* Mon Sep 5 2016 John H. Bennett III <bennettj@johnbennettservices.com> - 2.1.1-1
- Updated to 2.1.1

* Wed Jul 27 2016 John H. Bennett III <bennettj@johnbennettservices.com> - 2.1.0-1
- Updated to 2.1.0

* Wed Mar 23 2016 John H. Bennett III <bennettj@johnbennettservices.com> - 2.0.10-1
- Updated to 2.0.10

* Tue Feb 24 2016 John H. Bennett III <bennettj@johnbennettservices.com> - 2.0.9-1
- Updated to 2.0.9

* Sun Feb 7 2016 John H. Bennett III <bennettj@johnbennettservices.com> - 2.0.8-1
- Updated to 2.0.8

* Wed Jun 6 2015 John H. Bennett III <bennettj@johnbennettservices.com> - 2.0.7-1
- Updated to 2.0.7

* Sat Jan 10 2015 John H. Bennett III <bennettj@johnbennettservices.com> - 2.0.6-1
- Updated to 2.0.6

* Wed Mar 5 2014 John H. Bennett III <bennettj@johnbennettservices.com> - 2.0.5-1
- Updated to 2.0.5

* Sun Jul 7 2013 John H. Bennett III <bennettj@johnbennettservices.com> - 2.0.4-1
- Updated to 2.0.4

* Tue Jun 4 2013 John H. Bennett III <bennettj@johnbennettservices.com> - 2.0.3-1
- Initial release for SME Server
- Original build from pear make-rpm-spec
