%{!?__pear: %{expand: %%global __pear %{_bindir}/pear}}
%global pear_name Net_FTP

Name:           php-pear-Net-FTP
Version:        1.4.1
Release:        1%{?dist}
Summary:        Provides an OO interface to the PHP FTP functions plus some additions

Group:          Development/Libraries
License:        PHP
URL:            http://pear.php.net/package/Net_FTP
Source0:        http://pear.php.net/get/%{pear_name}-%{version}.tgz

# See http://pear.php.net/bugs/bug.php?id=13946
# Get http://cvs.php.net/viewvc.cgi/pear/Net_FTP/tests/Net_FTPTest.php?r1=1.7.2.5&r2=1.7.2.6&view=patch
#Patch0:         %{pear_name}-1.3.7-test.patch

BuildRoot:      %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)

BuildArch:      noarch
BuildRequires:  php-pear >= 1:1.4.9-1.2 dos2unix
Requires:       php-pear(PEAR) >= 1.3.0
Requires(post): %{__pear}
Requires(postun): %{__pear}
Provides:       php-pear(%{pear_name}) = %{version}


%description
Net_FTP allows you to communicate with FTP servers in a more comfortable
way than the native FTP functions of PHP do. The class implements everything
nativly supported by PHP and additionally features like recursive up- and
downloading, dircreation and chmodding. It although implements an observer
pattern to allow for example the view of a progress bar.


%prep
%setup -q -c
[ -f package2.xml ] || mv package.xml package2.xml
mv package2.xml %{pear_name}-%{version}/%{name}.xml

cd %{pear_name}-%{version}


%build
cd %{pear_name}-%{version}
# Empty build section, most likely nothing required.


%install
rm -rf $RPM_BUILD_ROOT docdir
cd %{pear_name}-%{version}
%{__pear} install --nodeps --packagingroot $RPM_BUILD_ROOT %{name}.xml

# Move documentation
mv $RPM_BUILD_ROOT%{pear_docdir}/%{pear_name} ../docdir

# Fix  wrong-file-end-of-line-encoding
dos2unix ../docdir/example/* CHANGELOG


# Clean up unnecessary files
rm -rf $RPM_BUILD_ROOT%{pear_phpdir}/.??*

# Install XML package description
mkdir -p $RPM_BUILD_ROOT%{pear_xmldir}
install -pm 644 %{name}.xml $RPM_BUILD_ROOT%{pear_xmldir}

# Patch applied here (don't break checksum control during install)
# cd $RPM_BUILD_ROOT%{pear_testdir}/Net_FTP
# dos2unix Net_FTPTest.php
# patch -p0 <%{PATCH0}


%clean
rm -rf $RPM_BUILD_ROOT


%post
%{__pear} install --nodeps --soft --force --register-only \
    %{pear_xmldir}/%{name}.xml >/dev/null || :

%postun
if [ $1 -eq 0 ] ; then
    %{__pear} uninstall --nodeps --ignore-errors --register-only \
        %{pear_name} >/dev/null || :
fi


%files
%defattr(-,root,root,-)
%doc docdir/example %{pear_name}-%{version}/CHANGELOG

%{pear_xmldir}/%{name}.xml
%{pear_phpdir}/Net
%{pear_testdir}/Net_FTP
%{pear_datadir}/Net_FTP


%check
# yum install php-pear-Net-FTP
# yum install php-pear-PHPUnit  # (tested with 3.2.15)
# cd /usr/share/pear/test/Net_FTP
# cp config.php.dist config.php
# vi config.php
# php AllTests.php
# should display : OK (9 tests)


%changelog
* Wed Oct 7 2020 John H. Bennett III <bennettj@johnbennettservices.com> 1.4.1-1
- Updated to 1.4.1

* Sun Mar 22 2015 John H. Bennett III <bennettj@johnbennettservices.com> 1.4.0-1
- Updated to 1.4.0

* Sat May 22 2010 Remi Collet <Fedora@FamilleCollet.com> 1.3.7-4
- spec cleanup
- rename Net_FTP.xml to php-pear-Net-FTP.xml

* Sun Jul 26 2009 Fedora Release Engineering <rel-eng@lists.fedoraproject.org> - 1.3.7-3
- Rebuilt for https://fedoraproject.org/wiki/Fedora_12_Mass_Rebuild

* Thu Feb 26 2009 Fedora Release Engineering <rel-eng@lists.fedoraproject.org> - 1.3.7-2
- Rebuilt for https://fedoraproject.org/wiki/Fedora_11_Mass_Rebuild

* Tue May 20 2008 Remi Collet <Fedora@FamilleCollet.com> 1.3.7-1
- new version
- add Net_FTP-1.3.7-test.patch for test suite (from CVS)

* Thu May 08 2008 Remi Collet <Fedora@FamilleCollet.com> 1.3.6-1
- new version

* Tue Dec 11 2007 Remi Collet <Fedora@FamilleCollet.com> 1.3.4-1
- new version

* Thu Dec  6 2007 Remi Collet <Fedora@FamilleCollet.com> 1.3.3-1
- new version
- fix license
- add %%check (for documentation only)

* Sun Nov  5 2006 Remi Collet <Fedora@FamilleCollet.com> 1.3.2-1
- initial RPM (generated specfile + cleanup)
- add CHANGELOG and LICENSE
