%define peardir /usr/share/pear
%define xmldir  /var/lib/pear

Summary: PEAR: Horde Text Filter API
Name: Horde_Text_Filter
Version: 2.3.6
Release: 1%{?dist}
License: LGPL-2.1
Group: Development/Libraries
Source0: http://pear.horde.org/get/Horde_Text_Filter-%{version}.tgz
BuildRoot: %{_tmppath}/%{name}-%{version}-root-%(%{__id_u} -n)
URL: http://pear.horde.org/package/Horde_Text_Filter
BuildRequires:       php-pear(PEAR) >= 1.4.7
BuildRequires: php-channel(pear.horde.org)
Requires: Horde_Role >= 1.0.0
Requires: Horde_Exception >= 2.0.0
Requires: Horde_Exception < 3.0.0alpha1
Requires: Horde_Util >= 2.0.0
Requires: Horde_Util < 3.0.0alpha1
Requires: php-pear(PEAR) >= 1.7.0
Requires: php-channel(pear.horde.org)
BuildArch: noarch

Provides:       %{name} = %{version}

%description
Common methods for fitering and converting text.

%prep
%setup -c -T
pear -v -c pearrc \
        -d php_dir=%{peardir} \
        -d doc_dir=%{pear_docdir} \
        -d bin_dir=%{_bindir} \
        -d data_dir=%{peardir}/data \
        -d test_dir=%{peardir}/tests \
        -d ext_dir=%{_libdir} \
        -d horde_dir=%{pear_hordedir} \
        -s

%build

%install
rm -rf %{buildroot}
pear -c pearrc install --nodeps --packagingroot %{buildroot} %{SOURCE0}
        
# Clean up unnecessary files
rm pearrc
rm %{buildroot}/%{peardir}/.filemap
rm %{buildroot}/%{peardir}/.lock
rm -rf %{buildroot}/%{peardir}/.registry
rm -rf %{buildroot}%{peardir}/.channels
rm %{buildroot}%{peardir}/.depdb
rm %{buildroot}%{peardir}/.depdblock

#mv %{buildroot}/docs .


# Install XML package description
mkdir -p %{buildroot}%{xmldir}
tar -xzf %{SOURCE0} package.xml
cp -p package.xml %{buildroot}%{xmldir}/Horde_Text_Filter.xml

%clean
rm -rf %{buildroot}

%post
pear install --nodeps --soft --force --register-only %{xmldir}/Horde_Text_Filter.xml >/dev/null || :

%postun
if [ "$1" -eq "0" ]; then
    pear uninstall --nodeps --ignore-errors --register-only pear.horde.org/Horde_Text_Filter >/dev/null || :
fi

%files
%defattr(-,root,root)
#%doc docs/Horde_Text_Filter/*
%{peardir}/*
%{xmldir}/Horde_Text_Filter.xml

%changelog
* Wed Jan 16 2019 John H. Bennett III <bennettj@johnbennettservices.com> - 2.3.6-1
- Updated to 2.3.6

* Tue Sep 6 2016 John H. Bennett III <bennettj@johnbennettservices.com> - 2.3.5-1
- Updated to 2.3.5

* Wed Mar 23 2016 John H. Bennett III <bennettj@johnbennettservices.com> - 2.3.4-1
- Updated to 2.3.4

* Sun Feb 7 2016 John H. Bennett III <bennettj@johnbennettservices.com> - 2.3.3-1
- Updated to 2.3.3

* Sat Aug 1 2015 John H. Bennett III <bennettj@johnbennettservices.com> - 2.3.2-1
- Updated to 2.3.2

* Sat May 2 2015 John H. Bennett III <bennettj@johnbennettservices.com> - 2.3.1-1
- Updated to 2.3.1

* Sat Apr 4 2015 John H. Bennett III <bennettj@johnbennettservices.com> - 2.3.0-1
- Updated to 2.3.0

* Sat Jan 10 2015 John H. Bennett III <bennettj@johnbennettservices.com> - 2.2.2-1
- Updated to 2.2.2

* Tue May 13 2014 John H. Bennett III <bennettj@johnbennettservices.com> - 2.2.1-1
- Updated to 2.2.1

* Tue Nov 19 2013 John H. Bennett III <bennettj@johnbennettservices.com> - 2.2.0-1
- Updated to 2.2.0

* Thu Oct 24 2013 John H. Bennett III <bennettj@johnbennettservices.com> - 2.1.5-1
- Updated to 2.1.5

- Initial release for SME Server
* Tue Jun 4 2013 John H. Bennett III <bennettj@johnbennettservices.com> - 2.1.3-1
- Initial release for SME Server
- Original build from pear make-rpm-spec

