%{!?__pear: %{expand: %%global __pear %{_bindir}/pear}}
%define pear_name DB

Name:           php-pear-DB
Version:        1.8.2
Release:        1%{?dist}
Summary:        PEAR: Database Abstraction Layer

Group:          Development/Libraries
License:        PHP
URL:            http://pear.php.net/package/DB
Source0:        http://pear.php.net/get/%{pear_name}-%{version}.tgz
#Source2:        xml2changelog

BuildRoot:      %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)

BuildArch:      noarch
BuildRequires:  php-pear >= 1:1.4.9-1.2
Requires(post): %{__pear}
Requires(postun): %{__pear}
Provides:       php-pear(%{pear_name}) = %{version}
Requires:       php-common >= 4.2.0
Requires:       php-pear(PEAR)

%description
DB is a database abstraction layer providing:
* an OO-style query API
* portability features that make programs written for one DBMS work with
  other DBMS's
* a DSN (data source name) format for specifying database servers
* prepare/execute (bind) emulation for databases that don't support it natively
* a result object for each query response
* portable error codes
* sequence emulation
* sequential and non-sequential row fetching as well as bulk fetching
* formats fetched rows as associative arrays, ordered arrays or objects
* row limit support
* transactions support
* table information interface
* DocBook and phpDocumentor API documentation

DB layers itself on top of PHP's existing database extensions.

%prep
%setup -q -c
[ -f package2.xml ] || mv package.xml package2.xml
# %{_bindir}/php -n %{SOURCE2} package2.xml >CHANGELOG
mv package2.xml %{pear_name}-%{version}/%{pear_name}.xml

cd %{pear_name}-%{version}
# update run test suite
sed -e 's@^ *DB_TEST_PHP_PATH=.*$@DB_TEST_PHP_PATH=%{_libdir}/php/build@' \
    -e 's@^ *DB_TEST_PHP_CLI=.*$@DB_TEST_PHP_CLI=php@' \
    -e 's@^ *DB_TEST_DIR=.*$@DB_TEST_DIR=%{pear_testdir}/DB/tests@' \
    -e 's@TEST_PHP_EXECUTABLE=.*$@TEST_PHP_EXECUTABLE=%{_bindir}/php@' \
    tests/run.cvs >run1

sed -e 's@^ *DB_TEST_PHP_PATH=.*$@DB_TEST_PHP_PATH=%{_libdir}/php/build@' \
    -e 's@^ *DB_TEST_PHP_CLI=.*$@DB_TEST_PHP_CLI=php@' \
    -e 's@^ *DB_TEST_DIR=.*$@DB_TEST_DIR=%{pear_testdir}/DB/tests/driver@' \
    -e 's@TEST_PHP_EXECUTABLE=.*$@TEST_PHP_EXECUTABLE=%{_bindir}/php@' \
    tests/driver/run.cvs >run2


%build
cd %{pear_name}-%{version}
# Empty build section, most likely nothing required.


%install
cd %{pear_name}-%{version}
rm -rf $RPM_BUILD_ROOT docdir
%{__pear} install --nodeps --packagingroot $RPM_BUILD_ROOT %{pear_name}.xml

# Move documentation
mkdir -p docdir
mv $RPM_BUILD_ROOT%{pear_docdir}/* docdir


# Clean up unnecessary files
rm -rf $RPM_BUILD_ROOT%{pear_phpdir}/.??*

# Install XML package description
mkdir -p $RPM_BUILD_ROOT%{pear_xmldir}
install -pm 644 %{pear_name}.xml $RPM_BUILD_ROOT%{pear_xmldir}

# Install new test suite
install -pm 755 run1 $RPM_BUILD_ROOT%{pear_testdir}/DB/tests/run
install -pm 755 run2 $RPM_BUILD_ROOT%{pear_testdir}/DB/tests/driver/run
#install -pm 644 setup.inc $RPM_BUILD_ROOT%{pear_testdir}/DB/tests/driver/

mv docdir/%{pear_name}/doc/TESTERS .
iconv -f ISO-8859-1 -t UTF-8  TESTERS -o docdir/%{pear_name}/doc/TESTERS
touch -r TESTERS docdir/%{pear_name}/doc/TESTERS


%clean
rm -rf $RPM_BUILD_ROOT


%check
## can only be run as "root" after install
## because %{_libdir}/php/build not writable
#cd %{pear_testdir}/DB/tests
#./run
#cd %{pear_testdir}/DB/tests/driver
#./run


%post
%{__pear} install --nodeps --soft --force --register-only \
    %{pear_xmldir}/%{pear_name}.xml >/dev/null || :

%postun
if [ $1 -eq 0 ] ; then
    %{__pear} uninstall --nodeps --ignore-errors --register-only \
        %{pear_name} >/dev/null || :
fi


%files
%defattr(-,root,root,-)
#%doc CHANGELOG %{pear_name}-%{version}/docdir/%{pear_name}/doc/*
%{pear_xmldir}/%{pear_name}.xml
%{pear_phpdir}/DB*
%{pear_testdir}/DB
%exclude %{pear_testdir}/DB/tests/run.cvs
%exclude %{pear_testdir}/DB/tests/driver/*.cvs


%changelog
* Thu Nov 27 2014 John H. Bennett III <bennettj@johnbennettservices.com> - 1.8.2-1
- Updated to 1.8.2

* Sun May 5 2013 John H. Bennett III <bennettj@johnbennettservices.com> - 1.7.14-1
- Updated to 1.7.14

* Sun Jul 26 2009 Fedora Release Engineering <rel-eng@lists.fedoraproject.org> - 1.7.13-3
- Rebuilt for https://fedoraproject.org/wiki/Fedora_12_Mass_Rebuild

* Thu Feb 26 2009 Fedora Release Engineering <rel-eng@lists.fedoraproject.org> - 1.7.13-2
- Rebuilt for https://fedoraproject.org/wiki/Fedora_11_Mass_Rebuild

* Fri Sep 21 2007 Remi Collet <Fedora@FamilleCollet.com> 1.7.13-1
- update to 1.7.13
- fix TEXTERS encoding

* Thu Aug 23 2007 Remi Collet <Fedora@FamilleCollet.com> 1.7.12-2
- Fix License

* Mon Jul 23 2007 Remi Collet <Fedora@FamilleCollet.com> 1.7.12-1
- update to 1.7.12
- change requires from php to php-common
- update test suite to run (but only after install)
- add %%check, only for documentation purpose

* Mon Apr 30 2007 Remi Collet <Fedora@FamilleCollet.com> 1.7.11-1
- update to 1.7.11
- add generated CHANGELOG

* Sun Sep 10 2006 Tim Jackson <rpm@timj.co.uk> 1.7.6-7
- Update spec to new conventions (#198706)

* Wed Jun 28 2006 Tim Jackson <rpm@timj.co.uk> 1.7.6-6
- Move tests to peardir/test instead of peardir/tests (bug #196764)

* Wed May 17 2006 Tim Jackson <rpm@timj.co.uk> 1.7.6-5
- Moved package XML file to %%{peardir}/.pkgxml (see bug #190252)
- Abstracted package XML directory
- Removed some "-f"s on rm's to avoid masking possible errors

* Tue Jan 24 2006 Tim Jackson <rpm@timj.co.uk> 1.7.6-4
- Move package XML file to _libdir/php/pear rather than _var/lib/pear

* Tue Jan 24 2006 Tim Jackson <rpm@timj.co.uk> 1.7.6-3
- Requires(post,postun) php-pear

* Sat Dec 31 2005 Tim Jackson <rpm@timj.co.uk> 1.7.6-2
- Rearranged so it makes more sense
- Remove external license file
- peardir definition now comes from "pear config-get"
- BR php-pear
- shorten description
- be explicit about the files in the package
- use macro for /var
- remove versioning from pear(PEAR) dep; 1.0b1 is very old

* Sat Dec 31 2005 Tim Jackson <rpm@timj.co.uk> 1.7.6-1
- First RPM build
