%define peardir %(pear config-get php_dir 2> /dev/null || echo %{_datadir}/pear)
%define xmldir  /var/lib/pear
%global pear_name Net_Sieve

Summary: Handles talking to a sieve server
Name: php-pear-Net-Sieve
Version: 1.4.4
Release: 1%{?dist}
License: BSD
Group: Development/Libraries
Source0: http://pear.php.net/get/Net_Sieve-%{version}.tgz
BuildRoot: %{_tmppath}/%{name}-%{version}-root-%(%{__id_u} -n)
URL: http://pear.php.net/package/Net_Sieve

BuildRequires:  php-pear(PEAR) >= 1.7.0
Requires: php-pear(Net_Socket) >= 1.0
Requires: php-pear(PEAR) >= 1.4.0b1

Provides:       php-pear(%{pear_name}) = %{version}

#BuildRequires: PEAR::PEAR >= 1.4.7
#Requires: PEAR::Net_Socket >= 1.0
#Requires: PEAR::PEAR >= 1.0
#Requires: PEAR::PEAR >= 1.4.0b1

BuildArch: noarch

%description
This package provides an API to talk to servers implementing the
managesieve protocol. It can be used to install and remove sieve scripts,
mark them active etc.

%prep
%setup -c -T
pear -v -c pearrc \
        -d php_dir=%{peardir} \
        -d doc_dir=/docs \
        -d bin_dir=%{_bindir} \
        -d data_dir=%{peardir}/data \
        -d test_dir=%{peardir}/tests \
        -d ext_dir=%{_libdir} \
        -s

%build

%install
rm -rf %{buildroot}
pear -c pearrc install --nodeps --packagingroot %{buildroot} %{SOURCE0}
        
# Clean up unnecessary files
rm pearrc
rm %{buildroot}/%{peardir}/.filemap
rm %{buildroot}/%{peardir}/.lock
rm -rf %{buildroot}/%{peardir}/.registry
rm -rf %{buildroot}%{peardir}/.channels
rm %{buildroot}%{peardir}/.depdb
rm %{buildroot}%{peardir}/.depdblock



# Install XML package description
mkdir -p %{buildroot}%{xmldir}
tar -xzf %{SOURCE0} package.xml
cp -p package.xml %{buildroot}%{xmldir}/Net_Sieve.xml

%clean
rm -rf %{buildroot}

%post
pear install --nodeps --soft --force --register-only %{xmldir}/Net_Sieve.xml >/dev/null || :

%postun
if [ "$1" -eq "0" ]; then
    pear uninstall --nodeps --ignore-errors --register-only pear.php.net/Net_Sieve >/dev/null || :
fi

%files
%defattr(-,root,root)

%{peardir}/*
%{xmldir}/Net_Sieve.xml

%changelog
* Tue Sep 18 2018 John H. Bennett III <bennettj@johnbennettservices.com> - 1.4.4-1
- Updated to 1.4.4

* Sun Mar 25 2018 John H. Bennett III <bennettj@johnbennettservices.com> - 1.4.3-1
- Updated to 1.4.3

* Sat Jun 24 2017 John H. Bennett III <bennettj@johnbennettservices.com> - 1.4.1-1
- Updated to 1.4.1

* Wed May 24 2017 John H. Bennett III <bennettj@johnbennettservices.com> - 1.4.0-1
- Updated to 1.4.0

* Tue Jan 20 2015 John H. Bennett III <bennettj@johnbennettservices.com> - 1.3.4-1
- Updated to 1.3.4

* Tue Oct 21 2014 John H. Bennett III <bennettj@johnbennettservices.com> - 1.3.3-1
- Updated to 1.3.3

* Mon May 6 2013 John H. Bennett III <bennettj@johnbennettservices.com> - 1.3.2-2
- updated spec file requires section, and left original info remarked.

* Sun May 5 2013 John H. Bennett III <bennettj@johnbennettservices.com> - 1.3.2-1
- Original from pear-make-rpm-spec.
