%define peardir /usr/share/pear
%define xmldir  /var/lib/pear

Summary: PEAR: iCalendar API
Name: Horde_Icalendar
Version: 2.1.8
Release: 1%{?dist}
License: LGPL-2.1
Group: Development/Libraries
Source0: http://pear.horde.org/get/Horde_Icalendar-%{version}.tgz
BuildRoot: %{_tmppath}/%{name}-%{version}-root-%(%{__id_u} -n)
URL: http://pear.horde.org/package/Horde_Icalendar
BuildRequires:       php-pear(PEAR) >= 1.4.7
BuildRequires: php-channel(pear.horde.org)
Requires: Horde_Role >= 1.0.0
Requires: Horde_Date >= 2.0.0
Requires: Horde_Date < 3.0.0alpha1
Requires: Horde_Exception >= 2.0.0
Requires: Horde_Exception < 3.0.0alpha1
Requires: Horde_Mail >= 2.0.0
Requires: Horde_Mail < 3.0.0alpha1
Requires: Horde_Mime >= 2.0.0
Requires: Horde_Mime < 3.0.0alpha1
Requires: Horde_Support >= 2.0.0
Requires: Horde_Support < 3.0.0alpha1
Requires: Horde_Translation >= 2.0.0
Requires: Horde_Translation < 3.0.0alpha1
Requires: Horde_Util >= 2.0.0
Requires: Horde_Util < 3.0.0alpha1
Requires: php-pear(PEAR) >= 1.7.0
Requires: php-channel(pear.horde.org)
BuildArch: noarch

Provides:       %{name} = %{version}

%description
An API for dealing with iCalendar data.

%prep
%setup -c -T
pear -v -c pearrc \
        -d php_dir=%{peardir} \
        -d doc_dir=%{pear_docdir} \
        -d bin_dir=%{_bindir} \
        -d data_dir=%{peardir}/data \
        -d test_dir=%{peardir}/tests \
        -d ext_dir=%{_libdir} \
        -d horde_dir=%{pear_hordedir} \
        -s

%build

%install
rm -rf %{buildroot}
pear -c pearrc install --nodeps --packagingroot %{buildroot} %{SOURCE0}
        
# Clean up unnecessary files
rm pearrc
rm %{buildroot}/%{peardir}/.filemap
rm %{buildroot}/%{peardir}/.lock
rm -rf %{buildroot}/%{peardir}/.registry
rm -rf %{buildroot}%{peardir}/.channels
rm %{buildroot}%{peardir}/.depdb
rm %{buildroot}%{peardir}/.depdblock

#mv %{buildroot}/docs .


# Install XML package description
mkdir -p %{buildroot}%{xmldir}
tar -xzf %{SOURCE0} package.xml
cp -p package.xml %{buildroot}%{xmldir}/Horde_Icalendar.xml

%clean
rm -rf %{buildroot}

%post
pear install --nodeps --soft --force --register-only %{xmldir}/Horde_Icalendar.xml >/dev/null || :

%postun
if [ "$1" -eq "0" ]; then
    pear uninstall --nodeps --ignore-errors --register-only pear.horde.org/Horde_Icalendar >/dev/null || :
fi

%files
%defattr(-,root,root)
#%doc docs/Horde_Icalendar/*
%{peardir}/*
%{xmldir}/Horde_Icalendar.xml

%changelog
* Sun Sep 30 2018 John H. Bennett III <bennettj@johnbennettservices.com> - 2.1.8-1
- Updated to 2.1.8

* Tue Jul 25 2017 John H. Bennett III <bennettj@johnbennettservices.com> - 2.1.7-1
- Updated to 2.1.7

* Tue Mar 21 2017 John H. Bennett III <bennettj@johnbennettservices.com> - 2.1.6-1
- Updated to 2.1.6

* Wed Mar 23 2016 John H. Bennett III <bennettj@johnbennettservices.com> - 2.1.4-1
- Updated to 2.1.4

* Sun Feb 7 2016 John H. Bennett III <bennettj@johnbennettservices.com> - 2.1.3-1
- Updated to 2.1.3

* Wed Nov 18 2015 John H. Bennett III <bennettj@johnbennettservices.com> - 2.1.2-1
- Updated to 2.1.2

* Sat Aug 1 2015 John H. Bennett III <bennettj@johnbennettservices.com> - 2.1.1-1
- Updated to 2.1.1

* Thu Jun 18 2015 John H. Bennett III <bennettj@johnbennettservices.com> - 2.1.0-1
- Updated to 2.1.0

* Sat May 2 2015 John H. Bennett III <bennettj@johnbennettservices.com> - 2.0.11-1
- Updated to 2.0.11

* Tue Nov 25 2014 John H. Bennett III <bennettj@johnbennettservices.com> - 2.0.10-1
- Updated to 2.0.10

* Mon Jun 9 2014 John H. Bennett III <bennettj@johnbennettservices.com> - 2.0.9-1
- Updated to 2.0.9

* Tue Jul 16 2013 John H. Bennett III <bennettj@johnbennettservices.com> - 2.0.7-1
- Updated to 2.0.7

- Initial release for SME Server
- Original build from pear make-rpm-spec
