%define peardir /usr/share/pear
%define xmldir  /var/lib/pear

Summary: PEAR: A web based address book
Name: turba-h5
Version: 4.2.25
Release: 1%{?dist}
License: ASL
Group: Development/Libraries
Source0: http://pear.horde.org/get/turba-%{version}.tgz
BuildRoot: %{_tmppath}/%{name}-%{version}-root-%(%{__id_u} -n)
URL: http://pear.horde.org/package/turba
BuildRequires:       php-pear(PEAR) >= 1.4.7
BuildRequires: php-channel(pear.horde.org)
Requires: Horde_Role >= 1.0.0
Requires: content >= 2.0.3
Requires: content < 3.0.0alpha1
Requires: horde >= 5.0.0
Requires: horde < 6.0.0alpha1
Requires: Horde_Auth >= 2.0.0
Requires: Horde_Auth < 3.0.0alpha1
Requires: Horde_Core >= 2.0.0
Requires: Horde_Core < 3.0.0alpha1
Requires: Horde_Data >= 2.0.0
Requires: Horde_Data < 3.0.0alpha1
Requires: Horde_Date >= 2.0.0
Requires: Horde_Date < 3.0.0alpha1
Requires: Horde_Exception >= 2.0.0
Requires: Horde_Exception < 3.0.0alpha1
Requires: Horde_Form >= 2.0.0
Requires: Horde_Form < 3.0.0alpha1
Requires: Horde_Group >= 2.0.0
Requires: Horde_Group < 3.0.0alpha1
Requires: Horde_History >= 2.0.0
Requires: Horde_History < 3.0.0alpha1
Requires: Horde_Icalendar >= 2.0.0
Requires: Horde_Icalendar < 3.0.0alpha1
Requires: Horde_Mail >= 2.0.0
Requires: Horde_Mail < 3.0.0alpha1
Requires: Horde_Mime >= 2.0.0
Requires: Horde_Mime < 3.0.0alpha1
Requires: Horde_Nls >= 2.0.0
Requires: Horde_Nls < 3.0.0alpha1
Requires: Horde_Perms >= 2.0.0
Requires: Horde_Perms < 3.0.0alpha1
Requires: Horde_Prefs >= 2.0.0
Requires: Horde_Prefs < 3.0.0alpha1
Requires: Horde_Serialize >= 2.0.0
Requires: Horde_Serialize < 3.0.0alpha1
Requires: Horde_Share >= 2.0.0
Requires: Horde_Share < 3.0.0alpha1
Requires: Horde_Support >= 2.0.0
Requires: Horde_Support < 3.0.0alpha1
Requires: Horde_Url >= 2.0.0
Requires: Horde_Url < 3.0.0alpha1
Requires: Horde_Util >= 2.0.0
Requires: Horde_Util < 3.0.0alpha1
Requires: Horde_View >= 2.0.0
Requires: Horde_View < 3.0.0alpha1
Requires: php-pear(PEAR) >= 1.7.0
Requires: php-channel(pear.horde.org)
Obsoletes: turba-h3   
BuildArch: noarch

Provides:       %{name} = %{version}

%description
Turba is the Horde contact management application. Leveraging the Horde
framework to provide seamless integration with IMP and other Horde
applications, it supports storing contacts in SQL, LDAP, Kolab, and IMSP
address books.

%prep
%setup -c -T
pear -v -c pearrc \
        -d php_dir=%{peardir} \
        -d doc_dir=%{pear_docdir} \
        -d bin_dir=%{_bindir} \
        -d data_dir=%{peardir}/data \
        -d test_dir=%{peardir}/tests \
        -d ext_dir=%{_libdir} \
        -d horde_dir=%{pear_hordedir} \
        -s

%build

%install
rm -rf %{buildroot}
pear -c pearrc install --nodeps --packagingroot %{buildroot} %{SOURCE0}
        
# Clean up unnecessary files
rm pearrc
rm %{buildroot}/%{peardir}/.filemap
rm %{buildroot}/%{peardir}/.lock
rm -rf %{buildroot}/%{peardir}/.registry
rm -rf %{buildroot}%{peardir}/.channels
rm %{buildroot}%{peardir}/.depdb
rm %{buildroot}%{peardir}/.depdblock

#mv %{buildroot}/docs .


# Install XML package description
mkdir -p %{buildroot}%{xmldir}
tar -xzf %{SOURCE0} package.xml
cp -p package.xml %{buildroot}%{xmldir}/turba.xml

%clean
rm -rf %{buildroot}

%post
pear install --nodeps --soft --force --register-only %{xmldir}/turba.xml >/dev/null || :

%postun
if [ "$1" -eq "0" ]; then
    pear uninstall --nodeps --ignore-errors --register-only pear.horde.org/turba >/dev/null || :
fi

%files
%defattr(-,root,root)
#%doc docs/turba/*
%doc %{pear_hordedir}
%{peardir}/*
%{xmldir}/turba.xml
%{_bindir}/turba-convert-datatree-shares-to-sql
%{_bindir}/turba-convert-sql-shares-to-sqlng
%{_bindir}/turba-import-squirrelmail-file-abook
%{_bindir}/turba-import-squirrelmail-sql-abook
%{_bindir}/turba-import-vcards
%{_bindir}/turba-public-to-horde-share
%{_bindir}/turba-import-openxchange

%changelog
* Sat May 25 2019 John H. Bennett III <bennettj@johnbennettservices.com> - 4.2.25-1
- Updated to turba 4.2.25

* Sun Apr 21 2019 John H. Bennett III <bennettj@johnbennettservices.com> - 4.2.24-1
- Updated to turba 4.2.24

* Mon Aug 20 2018 John H. Bennett III <bennettj@johnbennettservices.com> - 4.2.23-1
- Updated to turba 4.2.23

* Wed Sep 20 2017 John H. Bennett III <bennettj@johnbennettservices.com> - 4.2.21-1
- Updated to turba 4.2.21

* Tue Aug 1 2017 John H. Bennett III <bennettj@johnbennettservices.com> - 4.2.20-1
- Updated to turba 4.2.20

* Tue Mar 21 2017 John H. Bennett III <bennettj@johnbennettservices.com> - 4.2.19-1
- Updated to turba 4.2.19

* Sun Dec 18 2016 John H. Bennett III <bennettj@johnbennettservices.com> - 4.2.18-1
- Updated to turba 4.2.18

* Sun Nov 6 2016 John H. Bennett III <bennettj@johnbennettservices.com> - 4.2.17-1
- Updated to turba 4.2.17

* Tue Sep 6 2016 John H. Bennett III <bennettj@johnbennettservices.com> - 4.2.16-1
- Updated to turba 4.2.16

* Tue Jul 26 2016 John H. Bennett III <bennettj@johnbennettservices.com> - 4.2.15-1
- Updated to turba 4.2.15

* Tue Apr 5 2016 John H. Bennett III <bennettj@johnbennettservices.com> - 4.2.14-1
- Updated to turba 4.2.14

* Sun Feb 7 2016 John H. Bennett III <bennettj@johnbennettservices.com> - 4.2.12-1
- Updated to turba 4.2.12

* Wed Oct 28 2015 John H. Bennett III <bennettj@johnbennettservices.com> - 4.2.11-1
- Updated to turba 4.2.11

* Fri Oct 23 2015 John H. Bennett III <bennettj@johnbennettservices.com> - 4.2.10-1
- Updated to turba 4.2.10

* Sat Aug 1 2015 John H. Bennett III <bennettj@johnbennettservices.com> - 4.2.8-1
- Updated to turba 4.2.8

* Thu Jun 18 2015 John H. Bennett III <bennettj@johnbennettservices.com> - 4.2.7-1
- Updated to turba 4.2.7

* Sat May 2 2015 John H. Bennett III <bennettj@johnbennettservices.com> - 4.2.6-1
- Updated to turba 4.2.6

* Tue Feb 10 2015 John H. Bennett III <bennettj@johnbennettservices.com> - 4.2.5-1
- Updated to turba 4.2.5

* Thu Dec 4 2014 John H. Bennett III <bennettj@johnbennettservices.com> - 4.2.4-1
- Updated to turba 4.2.4

* Wed Oct 29 2014 John H. Bennett III <bennettj@johnbennettservices.com> - 4.2.3-1
- Updated to turba 4.2.3

* Fri Sep 9 2014 John H. Bennett III <bennettj@johnbennettservices.com> - 4.2.2-1
- Updated to turba 4.2.2

* Mon Aug 4 2014 John H. Bennett III <bennettj@johnbennettservices.com> - 4.2.1-1
- Updated to turba 4.2.1

* Tue Jul 8 2014 John H. Bennett III <bennettj@johnbennettservices.com> - 4.2.0-1
- Updated to turba 4.2.0

* Mon Mar 10 2014 John H. Bennett III <bennettj@johnbennettservices.com> - 4.1.4-1
- Updated to turba 4.1.4

* Wed Oct 30 2013 John H. Bennett III <bennettj@johnbennettservices.com> - 4.1.3-1
- Updated to turba 4.1.3

* Fri Jun 30 2013 John H. Bennett III <bennettj@johnbennettservices.com> - 4.1.2-1
- Updated to turba 4.1.2

* Tue Jun 4 2013 John H. Bennett III <bennettj@johnbennettservices.com> - 4.0.4-1
- Initial release for SME Server
- Original build from pear make-rpm-spec

