%define peardir /usr/share/pear
%define xmldir  /var/lib/pear

Summary: PEAR: Horde Utility Libraries
Name: Horde_Util
Version: 2.5.9
Release: 1%{?dist}
License: LGPL-2.1
Group: Development/Libraries
Source0: http://pear.horde.org/get/Horde_Util-%{version}.tgz
BuildRoot: %{_tmppath}/%{name}-%{version}-root-%(%{__id_u} -n)
URL: http://pear.horde.org/package/Horde_Util
BuildRequires:       php-pear(PEAR) >= 1.4.7
BuildRequires: php-channel(pear.horde.org)
Requires: Horde_Role >= 1.0.0
Requires: php-channel(pear.horde.org)
BuildArch: noarch

Provides:       %{name} = %{version}

%description
These classes provide functionality useful for all kind of applications.

%prep
%setup -c -T
pear -v -c pearrc \
        -d php_dir=%{peardir} \
        -d doc_dir=%{pear_docdir} \
        -d bin_dir=%{_bindir} \
        -d data_dir=%{peardir}/data \
        -d test_dir=%{peardir}/tests \
        -d ext_dir=%{_libdir} \
        -d horde_dir=%{pear_hordedir} \
        -s

%build

%install
rm -rf %{buildroot}
pear -c pearrc install --nodeps --packagingroot %{buildroot} %{SOURCE0}
        
# Clean up unnecessary files
rm pearrc
rm %{buildroot}/%{peardir}/.filemap
rm %{buildroot}/%{peardir}/.lock
rm -rf %{buildroot}/%{peardir}/.registry
rm -rf %{buildroot}%{peardir}/.channels
rm %{buildroot}%{peardir}/.depdb
rm %{buildroot}%{peardir}/.depdblock

#mv %{buildroot}/docs .


# Install XML package description
mkdir -p %{buildroot}%{xmldir}
tar -xzf %{SOURCE0} package.xml
cp -p package.xml %{buildroot}%{xmldir}/Horde_Util.xml

%clean
rm -rf %{buildroot}

%post
pear install --nodeps --soft --force --register-only %{xmldir}/Horde_Util.xml >/dev/null || :

%postun
if [ "$1" -eq "0" ]; then
    pear uninstall --nodeps --ignore-errors --register-only pear.horde.org/Horde_Util >/dev/null || :
fi

%files
%defattr(-,root,root)
#%doc docs/Horde_Util/*
%{peardir}/*
%{xmldir}/Horde_Util.xml

%changelog
* Mon Nov 11 2019 John H. Bennett III <bennettj@johnbennettservices.com> - 2.5.9-1
- Updated to 2.5.9

* Wed Jul 27 2016 John H. Bennett III <bennettj@johnbennettservices.com> - 2.5.8-1
- Updated to 2.5.8

* Sun Feb 7 2016 John H. Bennett III <bennettj@johnbennettservices.com> - 2.5.7-1
- Updated to 2.5.7

* Sat Aug 1 2015 John H. Bennett III <bennettj@johnbennettservices.com> - 2.5.6-1
- Updated to 2.5.6

* Thu Apr 16 2015 John H. Bennett III <bennettj@johnbennettservices.com> - 2.5.5-1
- Updated to 2.5.5

* Thu Mar 5 2015 John H. Bennett III <bennettj@johnbennettservices.com> - 2.5.4-1
- Updated to 2.5.4

* Tue Feb 10 2015 John H. Bennett III <bennettj@johnbennettservices.com> - 2.5.3-1
- Updated to 2.5.3

* Sat Jan 3 2015 John H. Bennett III <bennettj@johnbennettservices.com> - 2.5.2-1
- Updated to 2.5.2

* Fri Aug 15 2014 John H. Bennett III <bennettj@johnbennettservices.com> - 2.5.1-1
- Updated to 2.5.1

* Thu Aug 7 2014 John H. Bennett III <bennettj@johnbennettservices.com> - 2.5.0-1
- Updated to 2.5.0

* Tue May 13 2014 John H. Bennett III <bennettj@johnbennettservices.com> - 2.4.0-1
- Updated to 2.4.0

* Sat Jun 29 2013 John H. Bennett III <bennettj@johnbennettservices.com> - 2.3.0-1
- Updated to 2.3.0

- Initial release for SME Server
- Original build from pear make-rpm-spec
