%define peardir /usr/share/pear
%define xmldir  /var/lib/pear

Summary: PEAR: Horde timeobjects application
Name: timeobjects
Version: 2.1.4
Release: 1%{?dist}
License: BSD-2-Clause
Group: Development/Libraries
Source0: http://pear.horde.org/get/timeobjects-%{version}.tgz
BuildRoot: %{_tmppath}/%{name}-%{version}-root-%(%{__id_u} -n)
URL: http://pear.horde.org/package/timeobjects
BuildRequires:       php-pear(PEAR) >= 1.4.7
BuildRequires: php-channel(pear.horde.org)
Requires: Horde_Role >= 1.0.0
Requires: Horde_Core >= 2.0.0
Requires: Horde_Core < 3.0.0alpha1
Requires: Horde_Date >= 2.0.0
Requires: Horde_Date < 3.0.0alpha1
Requires: Horde_Exception >= 2.0.0
Requires: Horde_Exception < 3.0.0alpha1
Requires: Horde_Url >= 2.0.0
Requires: Horde_Url < 3.0.0alpha1
Requires: Horde_Util >= 2.0.0
Requires: Horde_Util < 3.0.0alpha1
Requires: php-pear(PEAR) >= 1.7.0
Requires: php-channel(pear.horde.org)
BuildArch: noarch

Provides:       %{name} = %{version}

%description
The timeobjects application doesn't have an interface but provides streams
of events to any applications that can consume them, notably the Horde
calendar application. It contains drivers for facebook events and weather
forecasts and can easily be extended by custom drivers.

%prep
%setup -c -T
pear -v -c pearrc \
        -d php_dir=%{peardir} \
        -d doc_dir=%{pear_docdir} \
        -d bin_dir=%{_bindir} \
        -d data_dir=%{peardir}/data \
        -d test_dir=%{peardir}/tests \
        -d ext_dir=%{_libdir} \
        -d horde_dir=%{pear_hordedir} \
        -s

%build

%install
rm -rf %{buildroot}
pear -c pearrc install --nodeps --packagingroot %{buildroot} %{SOURCE0}
        
# Clean up unnecessary files
rm pearrc
rm %{buildroot}/%{peardir}/.filemap
rm %{buildroot}/%{peardir}/.lock
rm -rf %{buildroot}/%{peardir}/.registry
rm -rf %{buildroot}%{peardir}/.channels
rm %{buildroot}%{peardir}/.depdb
rm %{buildroot}%{peardir}/.depdblock

#mv %{buildroot}/docs .


# Install XML package description
mkdir -p %{buildroot}%{xmldir}
tar -xzf %{SOURCE0} package.xml
cp -p package.xml %{buildroot}%{xmldir}/timeobjects.xml

%clean
rm -rf %{buildroot}

%post
pear install --nodeps --soft --force --register-only %{xmldir}/timeobjects.xml >/dev/null || :

%postun
if [ "$1" -eq "0" ]; then
    pear uninstall --nodeps --ignore-errors --register-only pear.horde.org/timeobjects >/dev/null || :
fi

%files
%defattr(-,root,root)
#%doc docs/timeobjects/*
%doc %{pear_hordedir}
%{peardir}/*
%{xmldir}/timeobjects.xml

%changelog
* Wed Sep 20 2017 John H. Bennett III <bennettj@johnbennettservices.com> - 2.1.4-1
- Update to 2.1.4

* Sun Dec 18 2016 John H. Bennett III <bennettj@johnbennettservices.com> - 2.1.3-1
- Update to 2.1.3

* Tue Apr 5 2016 John H. Bennett III <bennettj@johnbennettservices.com> - 2.1.2-1
- Update to 2.1.2

* Sun Feb 7 2016 John H. Bennett III <bennettj@johnbennettservices.com> - 2.1.1-1
- Update to 2.1.1

* Tue May 13 2014 John H. Bennett III <bennettj@johnbennettservices.com> - 2.1.0-1
- Update to 2.1.0

* Fri Jun 21 2013 John H. Bennett III <bennettj@johnbennettservices.com> - 2.0.4-1
- Update to 2.0.4

* Tue Jun 4 2013 John H. Bennett III <bennettj@johnbennettservices.com> - 2.0.3-1
- Initial release for SME Server
- Original build from pear make-rpm-spec

