%define peardir %(pear config-get php_dir 2> /dev/null || echo %{_datadir}/pear)
%define xmldir  /var/lib/pear
%global pear_name Net_Socket  

Summary: PEAR: Network Socket Interface
#Name: PEAR::Net_Socket

Name: php-pear-Net-Socket
Version: 1.0.14
Release: 1%{?dist}
License: PHP License
Group: Development/Libraries
Source0: http://pear.php.net/get/Net_Socket-%{version}.tgz
BuildRoot: %{_tmppath}/%{name}-%{version}-root-%(%{__id_u} -n)
URL: http://pear.php.net/package/Net_Socket
#BuildRequires: PEAR::PEAR >= 1.4.7

BuildRequires:  php-pear(PEAR) >= 1.4.7
Provides:       php-pear(%{pear_name}) = %{version}

BuildArch: noarch

%description
Net_Socket is a class interface to TCP sockets.  It provides blocking
  and non-blocking operation, with different reading and writing modes
  (byte-wise, block-wise, line-wise and special formats like network
  byte-order ip addresses).

%prep
%setup -c -T
pear -v -c pearrc \
        -d php_dir=%{peardir} \
        -d doc_dir=/docs \
        -d bin_dir=%{_bindir} \
        -d data_dir=%{peardir}/data \
        -d test_dir=%{peardir}/tests \
        -d ext_dir=%{_libdir} \
        -s

%build

%install
rm -rf %{buildroot}
pear -c pearrc install --nodeps --packagingroot %{buildroot} %{SOURCE0}
        
# Clean up unnecessary files
rm pearrc
rm %{buildroot}/%{peardir}/.filemap
rm %{buildroot}/%{peardir}/.lock
rm -rf %{buildroot}/%{peardir}/.registry
rm -rf %{buildroot}%{peardir}/.channels
rm %{buildroot}%{peardir}/.depdb
rm %{buildroot}%{peardir}/.depdblock



# Install XML package description
mkdir -p %{buildroot}%{xmldir}
tar -xzf %{SOURCE0} package.xml
cp -p package.xml %{buildroot}%{xmldir}/Net_Socket.xml

%clean
rm -rf %{buildroot}

%post
pear install --nodeps --soft --force --register-only %{xmldir}/Net_Socket.xml >/dev/null || :

%postun
if [ "$1" -eq "0" ]; then
    pear uninstall --nodeps --ignore-errors --register-only pear.php.net/Net_Socket >/dev/null || :
fi

%files
%defattr(-,root,root)

%{peardir}/*
%{xmldir}/Net_Socket.xml

%changelog
* Fri Jun 21 2013 John H. Bennett III <bennettj@johnbennettservices.com> - 1.0.14-1
- Updated to 1.0.14

* Tue May 21 2013 John H. Bennett III <bennettj@johnbennettservices.com> - 1.0.12-2
- updated spec file requires section, and left original info remarked.

* Tue May 21 2013 John H. Bennett III <bennettj@johnbennettservices.com> - 1.0.12-1
- Original from pear-make-rpm-spec.
