%define peardir /usr/share/pear
%define xmldir  /var/lib/pear

Summary: PEAR: A web based task list manager
Name: nag-h5
Version: 4.2.19
Release: 1%{?dist}
License: GPL-2.0
Group: Development/Libraries
Source0: http://pear.horde.org/get/nag-%{version}.tgz
BuildRoot: %{_tmppath}/%{name}-%{version}-root-%(%{__id_u} -n)
URL: http://pear.horde.org/package/nag
BuildRequires:       php-pear(PEAR) >= 1.4.7
BuildRequires: php-channel(pear.horde.org)
Requires: Horde_Role >= 1.0.0
Requires: content >= 2.0.0
Requires: content < 3.0.0alpha1
Requires: horde >= 5.0.0
Requires: horde < 6.0.0alpha1
Requires: Horde_Auth >= 2.0.0
Requires: Horde_Auth < 3.0.0alpha1
Requires: Horde_Core >= 2.0.0
Requires: Horde_Core < 3.0.0alpha1
Requires: Horde_Data >= 2.0.0
Requires: Horde_Data < 3.0.0alpha1
Requires: Horde_Date >= 2.0.0
Requires: Horde_Date < 3.0.0alpha1
Requires: Horde_Date_Parser >= 2.0.0
Requires: Horde_Date_Parser < 3.0.0alpha1
Requires: Horde_Exception >= 2.0.0
Requires: Horde_Exception < 3.0.0alpha1
Requires: Horde_Form >= 2.0.0
Requires: Horde_Form < 3.0.0alpha1
Requires: Horde_Group >= 2.0.0
Requires: Horde_Group < 3.0.0alpha1
Requires: Horde_History >= 2.0.0
Requires: Horde_History < 3.0.0alpha1
Requires: Horde_Icalendar >= 2.0.0
Requires: Horde_Icalendar < 3.0.0alpha1
Requires: Horde_Mail >= 2.0.0
Requires: Horde_Mail < 3.0.0alpha1
Requires: Horde_Mime >= 2.0.0
Requires: Horde_Mime < 3.0.0alpha1
Requires: Horde_Perms >= 2.0.0
Requires: Horde_Perms < 3.0.0alpha1
Requires: Horde_Prefs >= 2.0.0
Requires: Horde_Prefs < 3.0.0alpha1
Requires: Horde_Routes >= 2.0.0
Requires: Horde_Routes < 3.0.0alpha1
Requires: Horde_Share >= 2.0.0
Requires: Horde_Share < 3.0.0alpha1
Requires: Horde_Support >= 2.0.0
Requires: Horde_Support < 3.0.0alpha1
Requires: Horde_Text_Filter >= 2.0.0
Requires: Horde_Text_Filter < 3.0.0alpha1
Requires: Horde_Url >= 2.0.0
Requires: Horde_Url < 3.0.0alpha1
Requires: Horde_Util >= 2.0.0
Requires: Horde_Util < 3.0.0alpha1
Requires: Horde_View >= 2.0.0
Requires: Horde_View < 3.0.0alpha1
Requires: php-pear(PEAR) >= 1.7.0
Requires: php-channel(pear.horde.org)
Obsoletes: nag-h3   
BuildArch: noarch

Provides:       %{name} = %{version}

%description
Nag is a web-based application built upon the Horde Application Framework
which provides a simple, clean interface for managing online task lists
(i.e., todo lists). It also includes strong integration with the other
Horde applications and allows users to share task lists or enable
light-weight project management.

%prep
%setup -c -T
pear -v -c pearrc \
        -d php_dir=%{peardir} \
        -d doc_dir=%{pear_docdir} \
        -d bin_dir=%{_bindir} \
        -d data_dir=%{peardir}/data \
        -d test_dir=%{peardir}/tests \
        -d ext_dir=%{_libdir} \
        -d horde_dir=%{pear_hordedir} \
        -s

%build

%install
rm -rf %{buildroot}
pear -c pearrc install --nodeps --packagingroot %{buildroot} %{SOURCE0}
        
# Clean up unnecessary files
rm pearrc
rm %{buildroot}/%{peardir}/.filemap
rm %{buildroot}/%{peardir}/.lock
rm -rf %{buildroot}/%{peardir}/.registry
rm -rf %{buildroot}%{peardir}/.channels
rm %{buildroot}%{peardir}/.depdb
rm %{buildroot}%{peardir}/.depdblock

#mv %{buildroot}/docs .


# Install XML package description
mkdir -p %{buildroot}%{xmldir}
tar -xzf %{SOURCE0} package.xml
cp -p package.xml %{buildroot}%{xmldir}/nag.xml

%clean
rm -rf %{buildroot}

%post
pear install --nodeps --soft --force --register-only %{xmldir}/nag.xml >/dev/null || :

%postun
if [ "$1" -eq "0" ]; then
    pear uninstall --nodeps --ignore-errors --register-only pear.horde.org/nag >/dev/null || :
fi

%files
%defattr(-,root,root)
#%doc docs/nag/*
%doc %{pear_hordedir}
%{peardir}/*
%{xmldir}/nag.xml
%{_bindir}/nag-convert-datatree-shares-to-sql
%{_bindir}/nag-convert-sql-shares-to-sqlng
%{_bindir}/nag-create-missing-add-histories-sql
%{_bindir}/nag-import-vtodos
%{_bindir}/nag-import-openxchange

%changelog
* Sun Sep 30 2018 John H. Bennett III <bennettj@johnbennettservices.com> - 4.2.19-1
- Updated to nag 4.2.19

* Wed Sep 21 2017 John H. Bennett III <bennettj@johnbennettservices.com> - 4.2.17-1
- Updated to nag 4.2.17

* Tue Aug 15 2017 John H. Bennett III <bennettj@johnbennettservices.com> - 4.2.16-1
- Updated to nag 4.2.16

* Tue Aug 1 2017 John H. Bennett III <bennettj@johnbennettservices.com> - 4.2.15-1
- Updated to nag 4.2.15

* Tue Mar 21 2017 John H. Bennett III <bennettj@johnbennettservices.com> - 4.2.14-1
- Updated to nag 4.2.14

* Wed Nov 9 2016 John H. Bennett III <bennettj@johnbennettservices.com> - 4.2.13-1
- Updated to nag 4.2.13

* Tue Sep 6 2016 John H. Bennett III <bennettj@johnbennettservices.com> - 4.2.11-1
- Updated to nag 4.2.11

* Tue Jul 26 2016 John H. Bennett III <bennettj@johnbennettservices.com> - 4.2.10-1
- Updated to nag 4.2.10

* Tue Apr 5 2016 John H. Bennett III <bennettj@johnbennettservices.com> - 4.2.9-1
- Updated to nag 4.2.9

* Sun Feb 7 2016 John H. Bennett III <bennettj@johnbennettservices.com> - 4.2.7-1
- Updated to nag 4.2.7

* Fri Oct 23 2015 John H. Bennett III <bennettj@johnbennettservices.com> - 4.2.6-1
- Updated to nag 4.2.6

* Thu Jun 18 2015 John H. Bennett III <bennettj@johnbennettservices.com> - 4.2.5-1
- Updated to nag 4.2.5

* Tue Feb 10 2015 John H. Bennett III <bennettj@johnbennettservices.com> - 4.2.4-1
- Updated to nag 4.2.4

* Fri Nov 22 2014 John H. Bennett III <bennettj@johnbennettservices.com> - 4.2.3-1
- Updated to nag 4.2.3

* Wed Oct 29 2014 John H. Bennett III <bennettj@johnbennettservices.com> - 4.2.2-1
- Updated to nag 4.2.2

* Mon Aug 4 2014 John H. Bennett III <bennettj@johnbennettservices.com> - 4.2.1-1
- Updated to nag 4.2.1

* Tue Jul 8 2014 John H. Bennett III <bennettj@johnbennettservices.com> - 4.2.0-1
- Updated to nag 4.2.0

* Mon Mar 10 2014 John H. Bennett III <bennettj@johnbennettservices.com> - 4.1.4-1
- Updated to nag 4.1.4

* Wed Oct 30 2013 John H. Bennett III <bennettj@johnbennettservices.com> - 4.1.3-1
- Updated to nag 4.1.3

* Fri Jun 30 2013 John H. Bennett III <bennettj@johnbennettservices.com> - 4.1.2-1
- Updated to nag 4.1.2

* Tue Jun 4 2013 John H. Bennett III <bennettj@johnbennettservices.com> - 4.0.3-1
- Initial release for SME Server
- Original build from pear make-rpm-spec

