# $Id: e-smith-ingo.spec,v 1.1 2013/02/14 16:15:45 slords Exp $

Summary: e-smith specific INGO configuration and templates.
%define name e-smith-ingo
Name: %{name}
%define version 2.7.0
%define release 3
Version: %{version}
Release: %{release}%{?dist}
License: GPL
Group: Networking/Daemons
Source: %{name}-%{version}.tar.gz
Patch1: e-smith-ingo_phpscl_73.patch
Patch2: e-smith-ingo_phpscl_tls.patch
BuildRoot: /var/tmp/%{name}-%{version}-%{release}-buildroot
BuildArchitectures: noarch
Requires: imp-h5 >= 6
Requires: ingo-h5 >= 3.0
Requires: e-smith-base >= 4.15.1
Requires: e-smith-apache >= 1.1.0-18
Requires: e-smith-lib >= 1.15.1-16
Requires: php
BuildRequires: e-smith-devtools >= 1.13.1-03
AutoReqProv: no
Obsoletes: smeserver-ingo-menuarray

%changelog 
* Sat Oct 24 2020 John H. Bennett III <bennettj@johnbennettservices.com> 2.7.0-3
- Patch to disable TLS for Sieve scripts for all PHP SCL versions > 5.6.
  There is an error thrown, and I don't know how to overcome that yet.

* Mon Jul 8 2019 John H. Bennett III <bennettj@johnbennettservices.com> 2.7.0-2
- Patch to disable TLS auth when using Horde 5.2, Sieve, and PHP SCL 7.3 as it currently doesn't work.

* Sun Jun 5 2016 John H. Bennett III <bennettj@johnbennettservices.com> 2.7.0-1
- Re-rolled and incremented version number so that it won't conflict with horde 3 rpms currently in SME 10.

* Wed Dec 30 2015 John H. Bennett III <bennettj@johnbennettservices.com> 2.5.0-12
- Patch to include additional apache ACL directory restrictions

* Sat Jan 11 2015 John H. Bennett III <bennettj@johnbennettservices.com> 2.5.0-11
- Patch that adds Filters as a top menu choice, instead of under Mail.

* Sat Jan 10 2015 John H. Bennett III <bennettj@johnbennettservices.com> 2.5.0-10
- Patch to change ingo backends.local.php to horde format

* Tue Sep 9 2014 John H. Bennett III <bennettj@johnbennettservices.com> 2.5.0-9
- Patch to ingo conf.php to add DB setting to change from prefs to sql storage driver
  To use config setprop horde IngoSqlPrefs enabled

* Sat Sep 6 2014 John H. Bennett III <bennettj@johnbennettservices.com> 2.5.0-8
- Patch to ingo conf.php to change storage from sql to prefs to migrated filters show up.

* Mon Jun 30 2014 John H. Bennett III <bennettj@johnbennettservices.com> 2.5.0-7
- Patch to ingo conf.php for 3.2 compatibility.

* Wed Mar 26 2014 John H. Bennett III <bennettj@johnbennettservices.com> 2.5.0-6
- Patch to send the majority of the output from horde table migration to /dev/null.
  Some log noise errors will still be seen depending on what tables are present from
  previous versions.

* Sun Jun 09 2013 John H. Bennett III <bennettj@johnbennettservices.com> 2.5.0-5
- Patch to update ingo backends.local.php to new format for ingo 3.1.0

* Wed Jun 05 2013 John H. Bennett III <bennettj@johnbennettservices.com> 2.5.0-4
- Updated spec file to require imp-h5 >=6 and ingo-h5 >=3

* Sat Mar 23 2013 John H. Bennett III <bennettj@johnbennettservices.com> 2.5.0-3
- Re-add patch after new stream created
- Update to remove 120MenuSettings and conf.menu.apps.php file as they aren't used
  with horde 5.x.

* Sat Mar 23 2013 John H. Bennett III <bennettj@johnbennettservices.com> 2.5.0-2
- Re-add patch after new stream created
- Update file id in conf.php so config shows up to date.

* Sat Mar 23 2013 John H. Bennett III <bennettj@johnbennettservices.com> 2.5.0-1
- Re-add patch after new stream created
- Update ingo templates to reflect changes in ingo 2.0.7

* Sat Mar 23 2013 John H. Bennett III <bennettj@johnbennettservices.com> 2.5.0-0
- Roll new stream for horde5 components and above under sme9

* Wed Feb 13 2013 Shad L. Lords <slords@mail.com> 2.4.0-1.sme
- Roll new stream for sme9

* Sun Nov 07 2010 John H. Bennett III <bennettj@johnbennettservices.com> 2.2.0-5
- Update e-smith-ingo templates to reflect changes in Ingo 1.2.5 [SME: 6352]

* Mon May 10 2010 John H. Bennett III <bennettj@johnbennettservices.com> 2.2.0-4
- Update e-smith-ingo templates to reflect changes in Ingo 1.2.4 [SME: 5940]

* Sat Feb 13 2010 John H. Bennett III <bennettj@johnbennettservices.com> 2.2.0-3
- Update e-smith-ingo templates to reflect changes in Ingo 1.2.3 [SME: 5777]

* Tue Oct 13 2009 John H. Bennett III <bennettj@johnbennettservices.com> 2.2.0-2
- Update e-smith-ingo templates to reflect changes in Ingo 1.2.2 [SME: 5511]

* Tue Oct 7 2008 Shad L. Lords <slords@mail.com> 2.2.0-1.sme
- Roll new stream to separate sme7/sme8 trees [SME: 4633]

* Tue Sep 16 2008 John H. Bennett III <bennettj@johnbennettservices.com> 1.2-2    
- Update to e-smith-ingo templates to reflect changes in Ingo 1.2.1 [SME: 4568]

* Wed Jun 18 2008 John H. Bennett III <bennettj@johnbennettservices.com> 1.2-1    
- Initial production build

* Sat May 24 2008 John H. Bennett III <bennettj@johnbennettservices.com> 1.2-02
- Updated to include changes in Ingo 1.2 RC3
- Re-rolled tarball

* Thu Apr 10 2008 John H. Bennett III <bennettj@johnbennettservices.com> 1.2-01
- Initial build
- Jump in package name to reflect new version of ingo

%description
This package adds necessary templates and configuration items
so that INGO will work properly on SME Server	

%prep
%setup

%patch1 -p1
%patch2 -p1

%build
 
perl createlinks

%install
rm -rf $RPM_BUILD_ROOT
(cd root   ; find . -depth -print | cpio -dump $RPM_BUILD_ROOT)
/sbin/e-smith/genfilelist $RPM_BUILD_ROOT > %{name}-%{version}-filelist
echo "%doc COPYING"          >> %{name}-%{version}-filelist

%clean 
rm -rf $RPM_BUILD_ROOT

%files -f %{name}-%{version}-filelist
%defattr(-,root,root)
