# $Id: smeserver-gollem.spec,v 1.1 2010/07/08 15:01:01 slords Exp $
# Authority: mrjhb3
# Name: John H. Bennett III

Summary: SME Server specific Gollem configuration and templates.
%define name smeserver-gollem
Name: %{name}
%define version 1.1
%define release 8
Version: %{version}
Release: %{release}%{?dist}
License: GPL
Group: Networking/Daemons
Source: %{name}-%{version}.tar.gz
Patch0: smeserver-gollem_2_upgrade.patch
Patch1: smeserver-gollem_gollem_3_update.patch
Patch2: smeserver-gollem_3_conf_menu_apps_php.patch
Patch3:  smeserver-gollem_backends_local_php.patch
Patch4:  smeserver-gollem_http_directive.patch
Patch5:  smeserver-gollem_hash.patch
BuildRoot: /var/tmp/%{name}-%{version}-%{release}-buildroot
BuildArchitectures: noarch
Requires: imp-h5 >= 6
Requires: gollem-h5 >= 3
Requires: e-smith-base >= 4.15.1
Requires: e-smith-apache >= 1.1.0-18
Requires: e-smith-lib >= 1.15.1-16
BuildRequires: e-smith-devtools >= 1.13.1-03
AutoReqProv: no

%changelog
* Sun Jun 15 2020 John H. Bennett III <bennettj@johnbennettservices.com> 1.1-8
- Beginning with horde 5.2.3, the Horde project is moving away from using $ID to using $Hash to
- verify componenta are up to date.  $Hash is the sha1sum of the specific components conf.xml file 

* Wed Dec 30 2015 John H. Bennett III <bennettj@johnbennettservices.com> 1.1-7
- Patch to include additional apache ACL directory restrictions

* Sat Jan 10 2015 John H. Bennett III <bennettj@johnbennettservices.com> 1.1-6
- Updated spec file to require imp-h5 >= 6 and gollem-h5 >= 3

* Sat Jan 10 2015 John H. Bennett III <bennettj@johnbennettservices.com> 1.1-5
- Patch to change gollem backends.local.php to horde format

* Thu Mar 28 2013 John H. Bennett III <bennettj@johnbennettservices.com> 1.1-4
- Patch to add db variables to enable local ftp and smb access for gollem
- config setprop horde ftp enable|disable
- config setprop horde smb enable|disable

* Tue Nov 27 2012 John H. Bennett III <bennettj@johnbennettservices.com> 1.1-3
- Update to remove 120MenuSettings and conf.menu.apps.php file as they aren't used
  with horde 5.x.

* Sat Nov 24 2012 John H. Bennett III <bennettj@johnbennettservices.com> 1.1-2
- Patch to horde registry.local.php to display File Manager on top menu screen.
  Update file id in conf.php so config shows up to date.

* Mon May 7 2012 John H. Bennett III <bennettj@johnbennettservices.com> 1.1-1
- Update gollem templates to reflect changes in gollem 2.0.2

* Mon Apr 23 2012 John H. Bennett III <bennettj@johnbennettservices.com> 1.1-0
- Re-rolled for gollem 2.0.x

* Wed Apr 8 2009 John H. Bennett III <bennettj@johnbennettservices.com> 1.0-18
- 2nd attempt - change requires for gollem-h3 so that it will really pull 
  in gollem-h3 properly during a yum update of smeserver-gollem [SME: 5152]

* Wed Apr 8 2009 John H. Bennett III <bennettj@johnbennettservices.com> 1.0-17
- Bump number so that an updated rpm will be used which should pull in gollem-h3
  properly [SME: 5152]

* Wed Apr 1 2009 John H. Bennett III <bennettj@johnbennettservices.com> 1.0-16
- Updated templates to support gollem 1.1

* Mon Mar 09 2009 John H. Bennett III <bennettj@johnbennettservices.com> 1.0-15
- Updated spec file to require gollem-h3 >= 1.04 so that a yum install
  smeserver-gollem will also pull in the most current version of gollem-h3

* Mon Dec 08 2008 John H. Bennett III <bennettj@johnbennettservices.com> 1.0-14
- Updated to fix typo in gollem httpd.conf template fragment

* Sun Apr 29 2007 Shad L. Lords <slords@mail.com>
- Clean up spec so package can be built by koji/plague

* Sat Mar 24 2007 John H. Bennett III <bennettj@johnbennettservices.com> 1.0-13
- Updated gollem template fragments per gollem 1.0.3.

* Thu Feb 1 2007 John H. Bennett III <bennettj@johnbennettservices.com> 1.0-12
- Patch to 100LocalFtp that changes the hostspec from ftp.yourdomain.com to localhost.

* Sun Dec 3 2006 John H. Bennett III <bennettj@johnbennettservices.com> 1.0-11
- Patch to change gollem-menu template from hidden to block.  This is a cosmetic
  fix so that the horde sidebar does not try to display a non-existent file.

* Sat Oct 7 2006 John H. Bennett III <bennettj@johnbennettservices.com> 1.0-10
- Modified gollem prefs.php template to set show dot files to off by default.
  Even if it's turned on by a user, they will not see those files as they are
  being filtered via patch 6.

* Wed Oct 4 2006 John H. Bennett III <bennettj@johnbennettservices.com> 1.0-9
- Added a regex filter to gollem's 100LocalFtp template that will not display
  files that start with . or the Maildir directory.

* Thu Jul 20 2006 John H. Bennett III <bennettj@johnbennettservices.com> 1.0-8
- Removed old patch 5 as no movement has been made on my bug request 1742
- Removed gollem templates-custom fragment and moved it to the templates directory 
  which will make gollem active and gollem-block hidden when this rpm is installed.

* Tue Jun 22 2006 John H. Bennett III <bennettj@johnbennettservices.com> 1.0-7
- Remove Patch 6
- Fix use of deprecated APIs in httpd.conf template fragment.

* Fri Jun 09 2006 John H. Bennett III <bennettj@johnbennettservices.com> 1.0-6
- Removed deprecated calls to esmith:db and esmith:config

* Wed Mar 22 2006 John H. Bennett III <bennettj@johnbennettservices.com> 1.0-5
- Added an includes statement to 120Menusettings that will grab the information
  in horde/conf.menu.apps.php.  This way each of the individual horde modules  
  don't have to repeatedly process the same template for the menu array section in conf.php.

* Sat Mar 18 2006 John H. Bennett III <bennettj@johnbennettservices.com> 1.0-4
- Added the ability to enable or disable gollem menu icon from showing up on the
  main webmail screen.  To enable config set gollem service MenuArray disabled|enabled
- e-smith-horde still needs to support this feature or manual intervention is
  required.

* Sat Mar 18 2006 John H. Bennett III <bennettj@johnbennettservices.com> 1.0-3
- Added templates-custom fragment for horde/registry.php to make gollem active 
  and gollem-block hidden until the master templates are re-worked in smeserver-horde 
  or it's decided to make each smeserver horde add-on module include their own specific
  registry.php templates.

* Mon Mar 6 2006 John H. Bennett III <bennettj@johnbennettservices.com> 1.0-2
- Changed root and home locations for backends.php template to defaults, 
  which is blank

* Thu Mar 2 2006 John H. Bennett III <bennettj@johnbennettservices.com> 1.0-1
- Re-rolled and updated templates to match Gollem 1.0.2-RC2

* Thu Mar 2 2006 John H. Bennett III <bennettj@johnbennettservices.com> 1.0
- Initial build

%description
This package adds necessary templates and configuration items
so that Gollem will work properly.

%prep
%setup

%patch0 -p1
%patch1 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p1
%patch5 -p1

%build
 
perl createlinks

%install
rm -rf $RPM_BUILD_ROOT
(cd root   ; find . -depth -print | cpio -dump $RPM_BUILD_ROOT)
/sbin/e-smith/genfilelist $RPM_BUILD_ROOT > %{name}-%{version}-filelist
echo "%doc COPYING"          >> %{name}-%{version}-filelist

%clean 
rm -rf $RPM_BUILD_ROOT

%pre

%preun

%post

%postun

%files -f %{name}-%{version}-filelist
%defattr(-,root,root)
