%define peardir /usr/share/pear
%define xmldir  /var/lib/pear

Summary: PEAR: API for tracking the history of an object
Name: Horde_History
Version: 2.3.6
Release: 1%{?dist}
License: LGPL-2.1
Group: Development/Libraries
Source0: http://pear.horde.org/get/Horde_History-%{version}.tgz
BuildRoot: %{_tmppath}/%{name}-%{version}-root-%(%{__id_u} -n)
URL: http://pear.horde.org/package/Horde_History
BuildRequires:       php-pear(PEAR) >= 1.4.7
BuildRequires: php-channel(pear.horde.org)
Requires: Horde_Role >= 1.0.0
Requires: Horde_Db >= 2.0.0
Requires: Horde_Db < 3.0.0alpha1
Requires: Horde_Exception >= 2.0.0
Requires: Horde_Exception < 3.0.0alpha1
Requires: php-pear(PEAR) >= 1.7.0
Requires: php-channel(pear.horde.org)
BuildArch: noarch

Provides:       %{name} = %{version}

%description
The Horde_History API provides a way to track changes on arbitrary pieces
of data in Horde applications.

%prep
%setup -c -T
pear -v -c pearrc \
        -d php_dir=%{peardir} \
        -d doc_dir=%{pear_docdir} \
        -d bin_dir=%{_bindir} \
        -d data_dir=%{peardir}/data \
        -d test_dir=%{peardir}/tests \
        -d ext_dir=%{_libdir} \
        -d horde_dir=%{pear_hordedir} \
        -s

%build

%install
rm -rf %{buildroot}
pear -c pearrc install --nodeps --packagingroot %{buildroot} %{SOURCE0}
        
# Clean up unnecessary files
rm pearrc
rm %{buildroot}/%{peardir}/.filemap
rm %{buildroot}/%{peardir}/.lock
rm -rf %{buildroot}/%{peardir}/.registry
rm -rf %{buildroot}%{peardir}/.channels
rm %{buildroot}%{peardir}/.depdb
rm %{buildroot}%{peardir}/.depdblock

#mv %{buildroot}/docs .


# Install XML package description
mkdir -p %{buildroot}%{xmldir}
tar -xzf %{SOURCE0} package.xml
cp -p package.xml %{buildroot}%{xmldir}/Horde_History.xml

%clean
rm -rf %{buildroot}

%post
pear install --nodeps --soft --force --register-only %{xmldir}/Horde_History.xml >/dev/null || :

%postun
if [ "$1" -eq "0" ]; then
    pear uninstall --nodeps --ignore-errors --register-only pear.horde.org/Horde_History >/dev/null || :
fi

%files
%defattr(-,root,root)
#%doc docs/Horde_History/*
%{peardir}/*
%{xmldir}/Horde_History.xml

%changelog
* Sun Feb 7 2016 John H. Bennett III <bennettj@johnbennettservices.com> - 2.3.6-1
- Updated to 2.3.6

* Sat Aug 1 2015 John H. Bennett III <bennettj@johnbennettservices.com> - 2.3.5-1  
- Updated to 2.3.5

* Sat May 2 2015 John H. Bennett III <bennettj@johnbennettservices.com> - 2.3.4-1  
- Updated to 2.3.4

* Wed Nov 19 2014 John H. Bennett III <bennettj@johnbennettservices.com> - 2.3.3-1  
- Updated to 2.3.3

* Wed May 21 2014 John H. Bennett III <bennettj@johnbennettservices.com> - 2.3.1-1  
- Updated to 2.3.1

* Thu Apr 3 2014 John H. Bennett III <bennettj@johnbennettservices.com> - 2.3.0-1  
- Updated to 2.3.0

* Wed Oct 16 2013 John H. Bennett III <bennettj@johnbennettservices.com> - 2.2.1-1
- Updated to 2.2.1

* Fri Aug 30 2013 John H. Bennett III <bennettj@johnbennettservices.com> - 2.2.0-1
- Updated to 2.2.0

* Fri Aug 2 2013 John H. Bennett III <bennettj@johnbennettservices.com> - 2.1.6-1
- Updated to 2.1.6

* Mon Jun 3 2013 John H. Bennett III <bennettj@johnbennettservices.com> - 2.0.2-1
- Initial release for SME Server
- Original build from pear make-rpm-spec

