%define peardir %(pear config-get php_dir 2> /dev/null || echo %{_datadir}/pear)
%define xmldir  /var/lib/pear

Summary: PEAR: Web-based file manager
Name: gollem-h5
Version: 3.0.13
Release: 1%{?dist}
License: GPL-2.0
Group: Development/Libraries
Source0: http://pear.horde.org/get/gollem-%{version}.tgz
BuildRoot: %{_tmppath}/%{name}-%{version}-root-%(%{__id_u} -n)
URL: http://pear.horde.org/package/gollem
BuildRequires: php-pear(PEAR) >= 1.4.7
BuildRequires: php-channel(pear.horde.org)
Requires: Horde_Role >= 1.0.0
Requires: horde >= 5.0.2
Requires: horde < 6.0.0alpha1
Requires: Horde_Auth >= 2.0.0
Requires: Horde_Auth < 3.0.0alpha1
Requires: Horde_Cache >= 2.0.0
Requires: Horde_Cache < 3.0.0alpha1
Requires: Horde_Core >= 2.1.5
Requires: Horde_Core < 3.0.0alpha1
Requires: Horde_Editor >= 2.0.0
Requires: Horde_Editor < 3.0.0alpha1
Requires: Horde_Exception >= 2.0.0
Requires: Horde_Exception < 3.0.0alpha1
Requires: Horde_Mime >= 2.0.0
Requires: Horde_Mime < 3.0.0alpha1
Requires: Horde_Mime_Viewer >= 2.0.0
Requires: Horde_Mime_Viewer < 3.0.0alpha1
Requires: Horde_Perms >= 2.0.0
Requires: Horde_Perms < 3.0.0alpha1
Requires: Horde_Secret >= 2.0.0
Requires: Horde_Secret < 3.0.0alpha1
Requires: Horde_Serialize >= 2.0.0
Requires: Horde_Serialize < 3.0.0alpha1
Requires: Horde_Support >= 2.0.0
Requires: Horde_Support < 3.0.0alpha1
Requires: Horde_Url >= 2.0.0
Requires: Horde_Url < 3.0.0alpha1
Requires: Horde_Util >= 2.0.0
Requires: Horde_Util < 3.0.0alpha1
Requires: Horde_Vfs >= 2.0.0
Requires: Horde_Vfs < 3.0.0alpha1
Requires: Horde_View >= 2.0.0
Requires: Horde_View < 3.0.0alpha1
Requires: php-pear(PEAR) >= 1.7.0
Requires: php-channel(pear.horde.org)
Obsoletes: gollem-h3
Provides:       %{name} = %{version}  

BuildArch: noarch

%description
Gollem is a web-based file manager, providing the ability to fully manage a
hierarchical file system stored in a variety of backends such as a SQL
database, as part of a real filesystem, or on FTP, Samba or SSH servers.

%prep
%setup -c -T
pear -v -c pearrc \
        -d php_dir=%{peardir} \
        -d doc_dir=%{pear_docdir} \
        -d bin_dir=%{_bindir} \
        -d data_dir=%{peardir}/data \
        -d test_dir=%{peardir}/tests \
        -d ext_dir=%{_libdir} \
        -d horde_dir=%{pear_hordedir} \
        -s

%build

%install
rm -rf %{buildroot}
pear -c pearrc install --nodeps --packagingroot %{buildroot} %{SOURCE0}
        
# Clean up unnecessary files
rm pearrc
rm %{buildroot}/%{peardir}/.filemap
rm %{buildroot}/%{peardir}/.lock
rm -rf %{buildroot}/%{peardir}/.registry
rm -rf %{buildroot}%{peardir}/.channels
rm %{buildroot}%{peardir}/.depdb
rm %{buildroot}%{peardir}/.depdblock


#mv %{buildroot}/docs .

# Install XML package description
mkdir -p %{buildroot}%{xmldir}
tar -xzf %{SOURCE0} package.xml
cp -p package.xml %{buildroot}%{xmldir}/gollem.xml

%clean
rm -rf %{buildroot}

%post
pear install --nodeps --soft --force --register-only %{xmldir}/gollem.xml >/dev/null || :

%postun
if [ "$1" -eq "0" ]; then
    pear uninstall --nodeps --ignore-errors --register-only pear.horde.org/gollem >/dev/null || :
fi

%files
%defattr(-,root,root)
#%doc %{peardir}
%doc %{pear_hordedir}
%{peardir}/*
%{xmldir}/gollem.xml

%changelog
* Mon Apr 20 2020 John H. Bennett III <bennettj@johnbennettservices.com> - 3.0.13-1
- Update to 3.0.13

* Wed Sep 21 2017 John H. Bennett III <bennettj@johnbennettservices.com> - 3.0.12-1
- Update to 3.0.12

* Tue Aug 1 2017 John H. Bennett III <bennettj@johnbennettservices.com> - 3.0.11-1
- Update to 3.0.11

* Sun Dec 18 2016 John H. Bennett III <bennettj@johnbennettservices.com> - 3.0.10-1
- Update to 3.0.10

* Tue Jul 26 2016 John H. Bennett III <bennettj@johnbennettservices.com> - 3.0.9-1
- Update to 3.0.9

* Wed Mar 23 2016 John H. Bennett III <bennettj@johnbennettservices.com> - 3.0.8-1
- Update to 3.0.8

* Sun Feb 7 2016 John H. Bennett III <bennettj@johnbennettservices.com> - 3.0.7-1
- Update to 3.0.7

* Fri Oct 23 2015 John H. Bennett III <bennettj@johnbennettservices.com> - 3.0.6-1
- Update to 3.0.6

* Wed Aug 5 2015 John H. Bennett III <bennettj@johnbennettservices.com> - 3.0.5-1
- Update to 3.0.5

* Sat Aug 1 2015 John H. Bennett III <bennettj@johnbennettservices.com> - 3.0.4-1
- Update to 3.0.4

* Mon Aug 4 2014 John H. Bennett III <bennettj@johnbennettservices.com> - 3.0.3-1
- Update to 3.0.3

* Mon Mar 10 2014 John H. Bennett III <bennettj@johnbennettservices.com> - 3.0.2-1
- Update to 3.0.2

* Wed Jun 12 2013 John H. Bennett III <bennettj@johnbennettservices.com> - 3.0.1-1
- Update to 3.0.1

* Mon Jun 3 2013 John H. Bennett III <bennettj@johnbennettservices.com> - 3.0.0-1
- Initial release for SME Server
- Original build from pear make-rpm-spec
