%define peardir %(pear config-get php_dir 2> /dev/null || echo %{_datadir}/pear)
%define xmldir  /var/lib/pear
%global pear_name Text_Wiki

Summary: PEAR: Transforms Wiki and BBCode markup into XHTML, LaTeX or plain text markup. This is the base engine for all of the Text_Wiki sub-classes
Name: php-pear-Text_Wiki
Version: 1.2.3
Release: 1%{?dist}
License: LGPL
Group: Development/Libraries
Source0: http://pear.php.net/get/Text_Wiki-%{version}.tgz
BuildRoot: %{_tmppath}/%{name}-%{version}-root-%(%{__id_u} -n)
URL: http://pear.php.net/package/Text_Wiki
BuildRequires:  php-pear(PEAR) >= 1.4.7

Provides:       php-pear(%{pear_name}) = %{version}

BuildArch: noarch

%description
The text transformation is done in 2 steps.
The chosen parser uses markup rules to tokenize the tags and content.
Renderers output the tokens and text into the requested format.
The tokenized form replaces the tags by a protected byte value associated
to an index in an options table. This form shares up to 50 rules by all
parsers and renderers.
The package is intented for versatile transformers as well as converters.
Text_Wiki is delivered with its own parser, which is used by Yawiki or
Horde's Wicked and three basic renderers: XHTML , LaTeX and plain text.
Strong sanitizing of XHTML is default.
Parsers (* and Renderers) exist for BBCode, Cowiki (*), Dokuwiki (*),
Mediawiki and Tikiwiki (*).
It is highly configurable and can be easily extended.

%prep
%setup -c -T
pear -v -c pearrc \
        -d php_dir=%{peardir} \
        -d doc_dir=/docs \
        -d bin_dir=%{_bindir} \
        -d data_dir=%{peardir}/data \
        -d test_dir=%{peardir}/tests \
        -d ext_dir=%{_libdir} \
        -s

%build

%install
rm -rf %{buildroot}
pear -c pearrc install --nodeps --packagingroot %{buildroot} %{SOURCE0}
        
# Clean up unnecessary files
rm pearrc
rm %{buildroot}/%{peardir}/.filemap
rm %{buildroot}/%{peardir}/.lock
rm -rf %{buildroot}/%{peardir}/.registry
rm -rf %{buildroot}%{peardir}/.channels
rm %{buildroot}%{peardir}/.depdb
rm %{buildroot}%{peardir}/.depdblock

mv %{buildroot}/docs .


# Install XML package description
mkdir -p %{buildroot}%{xmldir}
tar -xzf %{SOURCE0} package.xml
cp -p package.xml %{buildroot}%{xmldir}/Text_Wiki.xml

%clean
rm -rf %{buildroot}

%post
pear install --nodeps --soft --force --register-only %{xmldir}/Text_Wiki.xml >/dev/null || :

%postun
if [ "$1" -eq "0" ]; then
    pear uninstall --nodeps --ignore-errors --register-only pear.php.net/Text_Wiki >/dev/null || :
fi

%files
%defattr(-,root,root)
%doc docs/Text_Wiki/*
%{peardir}/*
%{xmldir}/Text_Wiki.xml

%changelog
* Wed Mar 20 2019 John H. Bennett III <bennettj@johnbennettservices.com> - 1.2.3-1
- Updated to 1.2.3

* Sat Sep 7 2013 John H. Bennett III <bennettj@johnbennettservices.com> - 1.2.1-1
- Original from pear-make-rpm-spec.
