%define peardir %(pear config-get php_dir 2> /dev/null || echo %{_datadir}/pear)
%define xmldir  /var/lib/pear

Summary: PEAR: IDNA backend normalization package
Name: Horde_Idna
Version: 1.1.2
Release: 1%{?dist}
License: BSD-2-Clause
Group: Development/Libraries
Source0: http://pear.horde.org/get/Horde_Idna-%{version}.tgz
BuildRoot: %{_tmppath}/%{name}-%{version}-root-%(%{__id_u} -n)
URL: http://pear.horde.org/package/Horde_Idna
BuildRequires:       php-pear(PEAR) >= 1.4.7
BuildRequires: php-channel(pear.horde.org)
Requires: Horde_Exception >= 2.0.0
Requires: Horde_Exception < 3.0.0alpha1
Requires: php-pear(PEAR) >= 1.7.0
Requires: php-channel(pear.horde.org)
BuildArch: noarch

Provides:       %{name} = %{version}

%description
Normalized access to various backends providing IDNA (Internationalized
Domain Names in Applications) support.

%prep
%setup -c -T
pear -v -c pearrc \
        -d php_dir=%{peardir} \
        -d doc_dir=%{pear_docdir} \
        -d bin_dir=%{_bindir} \
        -d data_dir=%{peardir}/data \
        -d test_dir=%{peardir}/tests \
        -d ext_dir=%{_libdir} \
        -d horde_dir=%{pear_hordedir} \
        -s        

%build

%install
rm -rf %{buildroot}
pear -c pearrc install --nodeps --packagingroot %{buildroot} %{SOURCE0}
        
# Clean up unnecessary files
rm pearrc
rm %{buildroot}/%{peardir}/.filemap
rm %{buildroot}/%{peardir}/.lock
rm -rf %{buildroot}/%{peardir}/.registry
rm -rf %{buildroot}%{peardir}/.channels
rm %{buildroot}%{peardir}/.depdb
rm %{buildroot}%{peardir}/.depdblock

#mv %{buildroot}/docs .


# Install XML package description
mkdir -p %{buildroot}%{xmldir}
tar -xzf %{SOURCE0} package.xml
cp -p package.xml %{buildroot}%{xmldir}/Horde_Idna.xml

%clean
rm -rf %{buildroot}

%post
pear install --nodeps --soft --force --register-only %{xmldir}/Horde_Idna.xml >/dev/null || :

%postun
if [ "$1" -eq "0" ]; then
    pear uninstall --nodeps --ignore-errors --register-only pear.horde.org/Horde_Idna >/dev/null || :
fi

%files
%defattr(-,root,root)
#%doc docs/Horde_Idna/*
%{peardir}/*
%{xmldir}/Horde_Idna.xml

%changelog
* Mon Nov 11 2019 John H. Bennett III <bennettj@johnbennettservices.com> - 1.1.2-1
- Updated to 1.1.2

* Sat Jun 24 2017 John H. Bennett III <bennettj@johnbennettservices.com> - 1.1.1-1
- Updated to 1.1.1

* Sat Mar 4 2017 John H. Bennett III <bennettj@johnbennettservices.com> - 1.1.0-1
- Updated to 1.1.0

* Sun Feb 7 2016 John H. Bennett III <bennettj@johnbennettservices.com> - 1.0.4-1
- Updated to 1.0.4

* Sat May 2 2015 John H. Bennett III <bennettj@johnbennettservices.com> - 1.0.3-1
- Updated to 1.0.3

* Thu Apr 16 2015 John H. Bennett III <bennettj@johnbennettservices.com> - 1.0.2-1
- Updated to 1.0.2

* Sat Jan 10 2015 John H. Bennett III <bennettj@johnbennettservices.com> - 1.0.1-1
- Original build from pear make-rpm-spec  
