%define peardir %(pear config-get php_dir 2> /dev/null || echo %{_datadir}/pear)
%define xmldir  /var/lib/pear
%global pear_name Net_DNS2

Summary: PHP5 Resolver library used to communicate with a DNS server
Name: php-pear-Net-DNS2
Version: 1.4.4
Release: 1%{?dist}
License: BSD License
Group: Development/Libraries
Source0: http://pear.php.net/get/Net_DNS2-%{version}.tgz
BuildRoot: %{_tmppath}/%{name}-%{version}-root-%(%{__id_u} -n)
URL: http://pear.php.net/package/Net_DNS2

BuildRequires:  php-pear(PEAR) >= 1.4.7
Provides:       php-pear(%{pear_name}) = %{version}

#BuildRequires: PEAR::PEAR >= 1.4.7

BuildArch: noarch

%description
Provides (roughly) the same functionality as Net_DNS, but using PHP5
objects, exceptions for error handling, better sockets support.

This release is (in most cases) 2x - 10x faster than Net_DNS, as well as
includes more RR's (including DNSSEC RR's), and improved sockets and
streams support.

%prep
%setup -c -T
pear -v -c pearrc \
        -d php_dir=%{peardir} \
        -d doc_dir=/docs \
        -d bin_dir=%{_bindir} \
        -d data_dir=%{peardir}/data \
        -d test_dir=%{peardir}/tests \
        -d ext_dir=%{_libdir} \
        -s

%build

%install
rm -rf %{buildroot}
pear -c pearrc install --nodeps --packagingroot %{buildroot} %{SOURCE0}
        
# Clean up unnecessary files
rm pearrc
rm %{buildroot}/%{peardir}/.filemap
rm %{buildroot}/%{peardir}/.lock
rm -rf %{buildroot}/%{peardir}/.registry
rm -rf %{buildroot}%{peardir}/.channels
rm %{buildroot}%{peardir}/.depdb
rm %{buildroot}%{peardir}/.depdblock

mv %{buildroot}/docs .


# Install XML package description
mkdir -p %{buildroot}%{xmldir}
tar -xzf %{SOURCE0} package.xml
cp -p package.xml %{buildroot}%{xmldir}/Net_DNS2.xml

%clean
rm -rf %{buildroot}

%post
pear install --nodeps --soft --force --register-only %{xmldir}/Net_DNS2.xml >/dev/null || :

%postun
if [ "$1" -eq "0" ]; then
    pear uninstall --nodeps --ignore-errors --register-only pear.php.net/Net_DNS2 >/dev/null || :
fi

%files
%defattr(-,root,root)
%doc docs/Net_DNS2/*
%{peardir}/*
%{xmldir}/Net_DNS2.xml

%changelog
* Mon Oct 1 2018 John H. Bennett III <bennettj@johnbennettservices.com> - 1.4.4-1
- Updated to 1.4.4

* Tue Mar 21 2017 John H. Bennett III <bennettj@johnbennettservices.com> - 1.4.3-1
- Updated to 1.4.3

* Mon Sep 5 2016 John H. Bennett III <bennettj@johnbennettservices.com> - 1.4.2-1
- Updated to 1.4.2

* Thu Apr 16 2015 John H. Bennett III <bennettj@johnbennettservices.com> - 1.4.1-1
- Updated to 1.4.1

* Thu Dec 18 2014 John H. Bennett III <bennettj@johnbennettservices.com> - 1.4.0-1
- Updated to 1.4.0

* Sat Nov 30 2013 John H. Bennett III <bennettj@johnbennettservices.com> - 1.3.2-1
- Updated to 1.3.2

* Fri Jun 21 2013 John H. Bennett III <bennettj@johnbennettservices.com> - 1.3.1-1
- Updated to 1.3.1

* Mon May 6 2013 John H. Bennett III <bennettj@johnbennettservices.com> - 1.3.0-2
- updated spec file requires section, and left original info remarked.

* Sun May 5 2013 John H. Bennett III <bennettj@johnbennettservices.com> - 1.3.0-1
- Original from pear-make-rpm-spec.
