%define peardir %(pear config-get php_dir 2> /dev/null || echo %{_datadir}/pear)
%define xmldir  /var/lib/pear
%global pear_name Cache_Lite

Summary: Fast and Safe little cache system
Name: php-pear-Cache-Lite
Version: 1.7.16
Release: 1%{?dist}
License: lgpl
Group: Development/Libraries
Source0: http://pear.php.net/get/Cache_Lite-%{version}.tgz
BuildRoot: %{_tmppath}/%{name}-%{version}-root-%(%{__id_u} -n)
URL: http://pear.php.net/package/Cache_Lite

BuildRequires:  php-pear(PEAR) >= 1.4.7
Requires: php-pear(PEAR) >= 1.5.4

Provides:       php-pear(%{pear_name}) = %{version}

#BuildRequires: PEAR::PEAR >= 1.4.7
#Requires: PEAR::PEAR
#Requires: PEAR::PEAR >= 1.5.4

BuildArch: noarch

%description
This package is a little cache system optimized for file containers. It is
fast and safe (because it
        uses file locking and/or anti-corruption tests).

%prep
%setup -c -T
pear -v -c pearrc \
        -d php_dir=%{peardir} \
        -d doc_dir=/docs \
        -d bin_dir=%{_bindir} \
        -d data_dir=%{peardir}/data \
        -d test_dir=%{peardir}/tests \
        -d ext_dir=%{_libdir} \
        -s

%build

%install
rm -rf %{buildroot}
pear -c pearrc install --nodeps --packagingroot %{buildroot} %{SOURCE0}
        
# Clean up unnecessary files
rm pearrc
rm %{buildroot}/%{peardir}/.filemap
rm %{buildroot}/%{peardir}/.lock
rm -rf %{buildroot}/%{peardir}/.registry
rm -rf %{buildroot}%{peardir}/.channels
rm %{buildroot}%{peardir}/.depdb
rm %{buildroot}%{peardir}/.depdblock

mv %{buildroot}/docs .


# Install XML package description
mkdir -p %{buildroot}%{xmldir}
tar -xzf %{SOURCE0} package.xml
cp -p package.xml %{buildroot}%{xmldir}/Cache_Lite.xml

%clean
rm -rf %{buildroot}

%post
pear install --nodeps --soft --force --register-only %{xmldir}/Cache_Lite.xml >/dev/null || :

%postun
if [ "$1" -eq "0" ]; then
    pear uninstall --nodeps --ignore-errors --register-only pear.php.net/Cache_Lite >/dev/null || :
fi

%files
%defattr(-,root,root)
%doc docs/Cache_Lite/*
%{peardir}/*
%{xmldir}/Cache_Lite.xml

%changelog
* Tue May 13 2014 John H. Bennett III <bennettj@johnbennettservices.com> - 1.7.16-1
- updated to 1.7.16

* Mon May 6 2013 John H. Bennett III <bennettj@johnbennettservices.com> - 1.7.15-2
- updated spec file requires section, and left original info remarked.

* Sun May 5 2013 John H. Bennett III <bennettj@johnbennettservices.com> - 1.7.15-1
- Original from pear-make-rpm-spec.


