%define peardir /usr/share/pear
%define xmldir  /var/lib/pear

Summary: PEAR: Fast Compression Library
Name: Horde_Compress_Fast
Version: 1.1.1
Release: 1%{?dist}
License: LGPL-2.1
Group: Development/Libraries
Source0: http://pear.horde.org/get/Horde_Compress_Fast-%{version}.tgz
BuildRoot: %{_tmppath}/%{name}-%{version}-root-%(%{__id_u} -n)
URL: http://pear.horde.org/package/Horde_Compress_Fast
BuildRequires:       php-pear(PEAR) >= 1.4.7
BuildRequires: php-channel(pear.horde.org)
Requires: Horde_Role >= 1.0.0
Requires: Horde_Exception >= 2.0.0
Requires: Horde_Exception < 3.0.0alpha1
Requires: php-pear(PEAR) >= 1.7.0
Requires: php-channel(pear.horde.org)
BuildArch: noarch

%description
Provides compression suitable for packing strings on-the-fly in PHP code
(as opposed to more resource-intensive compression algorithms such as
DEFLATE).

%prep
%setup -c -T
pear -v -c pearrc \
        -d php_dir=%{peardir} \
        -d doc_dir=%{pear_docdir} \
        -d bin_dir=%{_bindir} \
        -d data_dir=%{peardir}/data \
        -d test_dir=%{peardir}/tests \
        -d ext_dir=%{_libdir} \
        -d horde_dir=%{pear_hordedir} \
        -s

%build

%install
rm -rf %{buildroot}
pear -c pearrc install --nodeps --packagingroot %{buildroot} %{SOURCE0}
        
# Clean up unnecessary files
rm pearrc
rm %{buildroot}/%{peardir}/.filemap
rm %{buildroot}/%{peardir}/.lock
rm -rf %{buildroot}/%{peardir}/.registry
rm -rf %{buildroot}%{peardir}/.channels
rm %{buildroot}%{peardir}/.depdb
rm %{buildroot}%{peardir}/.depdblock

#mv %{buildroot}/docs .


# Install XML package description
mkdir -p %{buildroot}%{xmldir}
tar -xzf %{SOURCE0} package.xml
cp -p package.xml %{buildroot}%{xmldir}/Horde_Compress_Fast.xml

%clean
rm -rf %{buildroot}

%post
pear install --nodeps --soft --force --register-only %{xmldir}/Horde_Compress_Fast.xml >/dev/null || :

%postun
if [ "$1" -eq "0" ]; then
    pear uninstall --nodeps --ignore-errors --register-only pear.horde.org/Horde_Compress_Fast >/dev/null || :
fi

%files
%defattr(-,root,root)
#%doc docs/Horde_Compress_Fast/*
%{peardir}/*
%{xmldir}/Horde_Compress_Fast.xml

%changelog
* Sun Feb 7 2016 John H. Bennett III <bennettj@johnbennettservices.com> - 1.1.1-1
- Updated to 1.1.1

* Sat Jan 10 2015 John H. Bennett III <bennettj@johnbennettservices.com> - 1.1.0-1
- Updated to 1.1.0

* Tue Jul 8 2014 John H. Bennett III <bennettj@johnbennettservices.com> - 1.0.3-1
- Updated to 1.0.3

* Tue Jul 16 2013 John H. Bennett III <bennettj@johnbennettservices.com> - 1.0.2-1
- Updated to 1.0.2

* Mon Jun 3 2013 John H. Bennett III <bennettj@johnbennettservices.com> - 1.0.1-1
- Initial release for SME Server
- Original build from pear make-rpm-spec

