%define peardir /usr/share/pear
%define xmldir  /var/lib/pear

Summary: PEAR: Horde Mail Autoconfiguration
Name: Horde_Mail_Autoconfig
Version: 1.0.3
Release: 1%{?dist}
License: LGPL-2.1
Group: Development/Libraries
Source0: http://pear.horde.org/get/Horde_Mail_Autoconfig-%{version}.tgz
BuildRoot: %{_tmppath}/%{name}-%{version}-root-%(%{__id_u} -n)
URL: http://pear.horde.org/package/Horde_Mail_Autoconfig
BuildRequires:       php-pear(PEAR) >= 1.4.7
BuildRequires: php-channel(pear.horde.org)
Requires: Horde_Exception >= 2.0.0
Requires: Horde_Exception < 3.0.0alpha1
Requires: Horde_Http >= 2.0.0
Requires: Horde_Http < 3.0.0alpha1
Requires: Horde_Imap_Client >= 2.20.1
Requires: Horde_Imap_Client < 3.0.0alpha1
Requires: Horde_Mail >= 2.0.0
Requires: Horde_Mail < 3.0.0alpha1
Requires: Horde_Smtp >= 1.1.0
Requires: Horde_Smtp < 2.0.0alpha1
Requires: php-pear-Net-DNS2 >= 1.3.0
Requires: php-pear(PEAR) >= 1.7.0
Requires: php-channel(pear.horde.org)
BuildArch: noarch

Provides:       %{name} = %{version}

%description
Attempts to automatically determine configuration options for various
remote mail services (IMAP/POP3/SMTP).

%prep
%setup -c -T
pear -v -c pearrc \
        -d php_dir=%{peardir} \
        -d doc_dir=%{pear_docdir} \
        -d bin_dir=%{_bindir} \
        -d data_dir=%{peardir}/data \
        -d test_dir=%{peardir}/tests \
        -d ext_dir=%{_libdir} \
        -d horde_dir=%{pear_hordedir} \
        -s

%build

%install
rm -rf %{buildroot}
pear -c pearrc install --nodeps --packagingroot %{buildroot} %{SOURCE0}
        
# Clean up unnecessary files
rm pearrc
rm %{buildroot}/%{peardir}/.filemap
rm %{buildroot}/%{peardir}/.lock
rm -rf %{buildroot}/%{peardir}/.registry
rm -rf %{buildroot}%{peardir}/.channels
rm %{buildroot}%{peardir}/.depdb
rm %{buildroot}%{peardir}/.depdblock

#mv %{buildroot}/docs .


# Install XML package description
mkdir -p %{buildroot}%{xmldir}
tar -xzf %{SOURCE0} package.xml
cp -p package.xml %{buildroot}%{xmldir}/Horde_Mail_Autoconfig.xml

%clean
rm -rf %{buildroot}

%post
pear install --nodeps --soft --force --register-only %{xmldir}/Horde_Mail_Autoconfig.xml >/dev/null || :

%postun
if [ "$1" -eq "0" ]; then
    pear uninstall --nodeps --ignore-errors --register-only pear.horde.org/Horde_Mail_Autoconfig >/dev/null || :
fi

%files
%defattr(-,root,root)
#%doc docs/Horde_Mail_Autoconfig/*
%{peardir}/*
%{xmldir}/Horde_Mail_Autoconfig.xml

%changelog
* Wed Mar 16 2016 John H. Bennett III <bennettj@johnbennettservices.com> - 1.0.3-1
- Updated to 1.0.3

* Sat Jan 10 2015 John H. Bennett III <bennettj@johnbennettservices.com> - 1.0.2-1
- Updated to 1.0.2

* Tue Oct 02 2014 John H. Bennett III <bennettj@johnbennettservices.com> - 1.0.1-1
- Updated to 1.0.1

* Tue Jul 1 2014 John H. Bennett III <bennettj@johnbennettservices.com> - 1.0.0-1
- Initial release for SME Server     
- Original build from pear make-rpm-spec
