<?php
/**
 * Console Getopt+ (Getopt Plus) tests
 *
 * PHP version 5
 *
 * All rights reserved.
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 * + Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * + Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation and/or
 * other materials provided with the distribution.
 * + The name of its contributors may not be used to endorse or promote products
 * derived from this software without specific prior written permission.
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * @category  PHP
 * @package   Console_GetoptPlus
 * @author    Michel Corne <mcorne@yahoo.com>
 * @copyright 2008 Michel Corne
 * @license   http://www.opensource.org/licenses/bsd-license.php The BSD License
 * @version   SVN: $Id: GetoptPlusTest.php 47 2008-01-10 11:03:38Z mcorne $
 * @link      http://pear.php.net/package/Console_GetoptPlus
 */
// Call tests_GetoptPlusTest::main() if this source file is executed directly
if (!defined("PHPUnit_MAIN_METHOD")) {
    define("PHPUnit_MAIN_METHOD", "tests_GetoptPlusTest::main");
}

require_once "PHPUnit/Framework/TestCase.php";
require_once "PHPUnit/Framework/TestSuite.php";

require_once 'Console/GetoptPlus.php';

/**
 * Test class for PHP_GetoptPlus.
 * Generated by PHPUnit_Util_Skeleton on 2007-05-18 at 18:49:09.
 *
 * @category  PHP
 * @package   Console_GetoptPlus
 * @author    Michel Corne <mcorne@yahoo.com>
 * @copyright 2008 Michel Corne
 * @license   http://www.opensource.org/licenses/bsd-license.php The BSD License
 * @version   Release:@package_version@
 * @link      http://pear.php.net/package/Console_GetoptPlus
 */
class tests_GetoptPlusTest extends PHPUnit_Framework_TestCase
{
    private $getoptplus;

    /**
     * Runs the test methods of this class.
     *
     * @access public
     * @static
     */
    public static function main()
    {
        require_once "PHPUnit/TextUI/TestRunner.php";

        $suite = new PHPUnit_Framework_TestSuite("PHP_GetoptPlusTest");
        $result = PHPUnit_TextUI_TestRunner::run($suite);
    }

    /**
     * Sets up the fixture, for example, open a network connection.
     * This method is called before a test is executed.
     *
     * @access protected
     */
    protected function setUp()
    {
        $this->getoptplus = new Console_GetoptPlus();
    }

    /**
     * Tears down the fixture, for example, close a network connection.
     * This method is called after a test is executed.
     *
     * @access protected
     */
    protected function tearDown()
    {
    }

    /**
     * Tests checkOptionsConfig()
     */
    public function testCheckOptionsConfig()
    {
        // format: <options configuration>, <expected option configuration>
        $test = array(// /
            // valid options
            0 => array(// /
                array(array('long' => 'foo', 'type' => 'noarg')),
                array(// /
                    array('long' => 'foo', 'type' => 'noarg'),
                    array('long' => 'help', 'type' => 'noarg', 'desc' => 'This help.', 'short' => 'h'))),
            1 => array(
                array(array('long' => 'foo', 'type' => 'noarg'), array('long' => 'bar')),
                array(// /
                    array('long' => 'foo', 'type' => 'noarg'),
                    array('long' => 'bar', 'type' => 'noarg'),
                    array('long' => 'help', 'type' => 'noarg', 'desc' => 'This help.', 'short' => 'h'))),
            2 => array(array(// /
                    array('long' => 'foo', 'type' => 'noarg'),
                    array('long' => 'help', 'desc' => 'Another help.')),
                array(// /
                    array('long' => 'foo', 'type' => 'noarg'),
                    array('long' => 'help', 'type' => 'noarg', 'desc' => 'Another help.', 'type' => 'noarg'))),
            3 => array(array(// /
                    array('long' => 'foo', 'type' => 'noarg', 'short' => 'h')),
                array(// /
                    array('long' => 'foo', 'type' => 'noarg', 'short' => 'h'),
                    array('long' => 'help', 'type' => 'noarg', 'desc' => 'This help.'))),
            // invalid options, in the order errors appear in createOptionsDef()
            10 => array(array(array('type' => 'noarg')), 30),
            11 => array(array(array('long' => 'foo', 'type' => '???')), 31),
            );
        foreach($test as $idx => $values) {
            list($optionsConfig, $expected) = $values;
            // checks the options configuration, possibly captures an exception
            try {
                $result = $this->getoptplus->checkOptionsConfig(array('options' => $optionsConfig));
                $msg = '';
            }
            catch(Console_GetoptPlus_Exception $e) {
                $result = $e->getCode();
                $msg = "\n" . $e->getMessage();
            }
            $this->assertEquals($expected, $result , 'test #' . $idx . $msg);
        }
    }

    /**
     * Tests createOptionsDef()
     */
    public function testCreateOptionsDef()
    {
        // format: <options configuration>, <expected option definitions>
        $test = array(// /
            // valid options
            0 => array(// /
                array(array('long' => 'foo', 'type' => 'noarg')),
                array('foo' => 'noarg')),
            1 => array(// /
                array(array('long' => 'foo', 'type' => 'noarg'), array('long' => 'bar', 'type' => 'noarg')),
                array('foo' => 'noarg', 'bar' => 'noarg')),
            // invalid options, in the order errors appear in createOptionsDef()
            10 => array(array(array('long' => 'foo?')), 21),
            11 => array(array(// /
                    array('long' => 'foo', 'type' => 'noarg'),
                    array('long' => 'bar', 'type' => 'noarg'),
                    array('long' => 'foo'), 'type' => 'noarg'),
                20),
            );
        foreach($test as $idx => $values) {
            list($optionsConfig, $expected) = $values;
            // creates the option definitions, possibly captures an exception
            try {
                $result = $this->getoptplus->createOptionsDef($optionsConfig, 'long', '~^\w+$~');
                $msg = '';
            }
            catch(Console_GetoptPlus_Exception $e) {
                $result = $e->getCode();
                $msg = "\n" . $e->getMessage();
            }
            $this->assertEquals($expected, $result , 'test #' . $idx . $msg);
        }
    }

    /**
     * Tests parseLongOptionsDef()
     */
    public function testParseLongOptionsDef()
    {
        // format: <options configuration>, <expected option definitions>
        $test = array(// /
            // valid options
            0 => array(// /
                array(array('long' => 'foo', 'type' => 'noarg')),
                array('foo' => 'noarg')),
            1 => array(// /
                array(array('long' => 'foo', 'type' => 'noarg'), array('short' => 'b', 'type' => 'noarg')),
                array('foo' => 'noarg')),
            // invalid options, in the order errors appear in createOptionsDef()
            10 => array(array(array('long' => 'foo?')), 21),
            );
        foreach($test as $idx => $values) {
            list($optionsConfig, $expected) = $values;
            // creates the option definitions, possibly captures an exception
            try {
                $result = $this->getoptplus->parseLongOptionsDef($optionsConfig);
                $msg = '';
            }
            catch(Console_GetoptPlus_Exception $e) {
                $result = $e->getCode();
                $msg = "\n" . $e->getMessage();
            }
            $this->assertEquals($expected, $result , 'test #' . $idx . $msg);
        }
    }

    /**
     * Tests parseShortOptionsDef()
     */
    public function testParseShortOptionsDef()
    {
        // format: <options configuration>, <expected option definitions>
        $test = array(// /
            // valid options
            0 => array(// /
                array(array('short' => 'f', 'type' => 'noarg')),
                array('f' => 'noarg')),
            1 => array(// /
                array(array('short' => 'f', 'type' => 'noarg'), array('long' => 'bar', 'type' => 'noarg')),
                array('f' => 'noarg')),
            // invalid options, in the order errors appear in createOptionsDef()
            10 => array(array(array('short' => 'f?')), 21),
            );
        foreach($test as $idx => $values) {
            list($optionsConfig, $expected) = $values;
            // creates the option definitions, possibly captures an exception
            try {
                $result = $this->getoptplus->parseShortOptionsDef($optionsConfig);
                $msg = '';
            }
            catch(Console_GetoptPlus_Exception $e) {
                $result = $e->getCode();
                $msg = "\n" . $e->getMessage();
            }
            $this->assertEquals($expected, $result , 'test #' . $idx . $msg);
        }
    }

    /**
     * Tests tidyOptions()
     */
    public function testTidyOptions()
    {
        // format <options>, <convert option names>, <convert to associative array>,
        // <expected tidied options>
        $test = array(// /
            // valid long options
            0 => array(array(array('--foo', null)), null, false, array(array('--foo', null))),
            1 => array(array(array('--foo', null)), null, true, array('foo' => '')),
            2 => array(array(array('--foo', null)), 'long2short', false, array(array('f', null))),
            3 => array(array(array('--foo', null)), 'long2short', true, array('f' => '')),
            4 => array(array(array('--foo', null)), 'short2long', false, array(array('--foo', ''))),
            5 => array(array(array('--foo', null)), 'short2long', true, array('foo' => '')),
            6 => array(array(array('--blah', null)), 'long2short', false, array(array('--blah', null))),
            7 => array(array(array('--blah', null)), 'long2short', true, array('blah' => '')),
            // valid short options
            10 => array(array(array('f', null)), null, false, array(array('f', null))),
            11 => array(array(array('f', null)), null, true, array('f' => '')),
            12 => array(array(array('f', null)), 'short2long', false, array(array('--foo', ''))),
            13 => array(array(array('f', null)), 'short2long', true, array('foo' => '')),
            14 => array(array(array('f', null)), 'long2short', false, array(array('f', null))),
            15 => array(array(array('f', null)), 'long2short', true, array('f' => '')),
            16 => array(array(array('c', null)), 'short2long', false, array(array('c', null))),
            17 => array(array(array('c', null)), 'short2long', true, array('c' => '')),
            // integrated
            20 => array(array(array('--foo', null), array('b', 1), array('--blah', 2)),
                null, false, array(array('--foo', null), array('b', 1), array('--blah', 2))),
            21 => array(array(array('--foo', null), array('b', 1), array('--blah', 2)),
                null, true, array('foo' => '', 'b' => 1, 'blah' => 2)),
            22 => array(array(array('--foo', null), array('b', 1), array('--blah', 2)),
                'long2short', false, array(array('f', null), array('b', 1), array('--blah', 2))),
            23 => array(array(array('--foo', null), array('b', 1), array('--blah', 2)),
                'short2long', true, array('foo' => '', 'bar' => 1, 'blah' => 2)),
            // help
            30 => array(array(array('--foo', null), array('--help', null)), null, true, '--help'),
            31 => array(array(array('--foo', null), array('--help', null)), 'long2short', true, 'h'),
            32 => array(array(array('--foo', null), array('--help', null)), 'short2long', true, '--help'),
            33 => array(array(array('--foo', null), array('h', null)), 'short2long', true, '--help'),
            34 => array(array(array('--foo', null), array('h', null)), null, true, 'h'),
            // invalid options, in the order errors appear in tidyOptions()
            40 => array(array(array('--foo', null)), 'bar', false, 32),
            );

        $optionsConfig = array(// /
            array('long' => 'foo', 'short' => 'f'),
            array('long' => 'bar', 'short' => 'b'),
            array('long' => 'blah'),
            array('short' => 'c'),
            array('long' => 'help', 'short' => 'h'),
            );
        $this->getoptplus->checkOptionsConfig(array('options' => $optionsConfig));

        foreach($test as $idx => $values) {
            list($options, $convertName, $toAssocArray, $expected) = $values;
            // tidies the option, possibly captures an exception
            try {
                $result = $this->getoptplus->tidyOptions($options, $convertName, $toAssocArray);
                $msg = '';
            }
            catch(Console_GetoptPlus_Exception $e) {
                $result = $e->getCode();
                $msg = "\n" . $e->getMessage();
            }
            $this->assertEquals($expected, $result , 'test #' . $idx . $msg);
        }
    }

    /**
     * Tests process()
     */
    public function testProcess()
    {
        global $argv;
        // format <argv>, <convert option names>, <return associative array>,
        // <expected processed options>
        $test = array(// /
            // valid long options
            0 => array(array('--foo', '--bar', 'blah', 'boo'), null, false,
                array(array(array('--foo', ''), array('--bar', 'blah')), array('boo'))),
            1 => array(array('--foo', '--bar', 'blah', 'boo'), null, true,
                array(array('foo' => '', 'bar' => 'blah'), array('boo'))),
            2 => array(array('--foo', '-b', 'blah', 'boo'), 'long2short', false,
                array(array(array('f', ''), array('b' , 'blah')), array('boo'))),
            3 => array(array('--foo', '-b', 'blah', 'boo'), 'short2long', true,
                array(array('foo' => '', 'bar' => 'blah'), array('boo'))),
            4 => array(array('-h'), null, null, array(// /
                    array(array('h', "Usage: command [options]\nOptions:\n-f --foo\n-b --bar <value>\n-h --help")),
                    array())),
            // invalid options
            10 => array(array('--foo', null), 'bar', false, 32),
            );

        $config['options'] = array(// /
            array('long' => 'foo', 'short' => 'f'),
            array('long' => 'bar', 'short' => 'b', 'type' => 'mandatory', 'desc' => 'value'),
            array('long' => 'help', 'short' => 'h'),
            );

        foreach($test as $idx => $values) {
            list($argv, $convertName, $returnAssoc, $expected) = $values;
            array_unshift($argv, 'command'); // adds the command
            // processes the option, possibly captures an exception
            try {
                $result = $this->getoptplus->process($config, $convertName, $returnAssoc, null, false);
                $msg = '';
            }
            catch(Console_GetoptPlus_Exception $e) {
                $result = $e->getCode();
                $msg = "\n" . $e->getMessage();
            }
            $this->assertEquals($expected, $result , 'test #' . $idx . $msg);
        }
    }

    /**
     * Tests getoptplus()
     */
    public function testGetoptplus()
    {
        global $argv;
        $argv = array('command');

        $result = Console_GetoptPlus::getoptplus();

        $this->assertEquals(array(array(), array()), $result);
    }
}
// Call tests_GetoptPlusTest::main() if this source file is executed directly.
if (PHPUnit_MAIN_METHOD == "tests_GetoptPlusTest::main") {
    tests_GetoptPlusTest::main();
}

?>
