%define version 0.2.64
%define release 1
%define name ipasserelle-base


Summary: Meta-Package to turn a SME Server into an iPasserelle
Name: ipasserelle-base
Version: 0.2.70
Release: 1%{?dist}
Epoch: 9
License: GPL
Group: Networking/Daemons
Source: %{name}-%{version}.tar.gz

BuildRoot: /var/tmp/%{name}-%{version}-%{release}-buildroot
BuildArchitectures: noarch
BuildRequires: e-smith-devtools

Requires: e-smith-base >= 5.2.0
Requires: e-smith-ldap
Requires: smeserver-remoteuseraccess
Requires: smeserver-zabbix-agent
Requires: smeserver-zabbix-proxy
Requires: logwatch
Requires: smeserver-shared-folders
Requires: smeserver-qos
Requires: smeserver-fetchmail
Requires: smeserver-webapps-common
Requires: smeserver-expire-accounts
Requires: bash-completion
Requires: ipasserelle-repo
Requires: qmail-notify
Requires: iftop
Requires: openssl-perl
Requires: perl(List::MoreUtils)
Requires: perl(Text::Unaccent::PurePerl)
Requires: perl(Net::LDAP)
Requires: perl(Proc::ProcessTable)
Requires: perl(Proc::ProcessTable::Process)
Requires: pbzip2
Requires: yum >= 3.2.29-69
Requires: smeserver-fail2ban
Obsoletes: smeserver-denyhosts
Obsoletes: smeserver-mailstats

%description
Meta package to configure an iPasserelle Server
Based on SMEServer, iPasserelle is a specially configured
SME Server, with some additionnal modules

%changelog
* Thu Dec 19 2019 Daniel Berteaud <daniel@firewall-services.com> 0.2.70-1
- Hide warning if year maildir already exists (daniel@firewall-services.com)

* Thu Mar 14 2019 Daniel Berteaud <daniel@firewall-services.com> 0.2.69-1
- Don't try to create or delete scan dir if no user has been passed
  (daniel@firewall-services.com)

* Tue Feb 06 2018 Daniel Berteaud <daniel@firewall-services.com> 0.2.68-1
- Handle Bcc being a fully qualified address in rotate script GLPI #30996
  (daniel@firewall-services.com)

* Wed Dec 06 2017 Daniel Berteaud <daniel@firewall-services.com> 0.2.67-1
- Typo in Category CGI param id (daniel@firewall-services.com)

* Wed Dec 06 2017 Daniel Berteaud <daniel@firewall-services.com> 0.2.66-1
- Remove GIT Changelog (daniel@firewall-services.com)

* Wed Dec 06 2017 Daniel Berteaud <daniel@firewall-services.com> 0.2.65-1
- new package built with tito
- Add Support for buisnessCategory LDAP field
* Wed Jul 19 2017 Daniel Berteaud <daniel@firewall-services.com> 0.2.64-1
- Reduce spamassassin's BL score to 1.0 each

* Thu Jun 8 2017 Daniel Berteaud <daniel@firewall-services.com> 0.2.63-1
- Set admins member full privileges on public mailboxes
  If smeserver-dovecot-extras >= 0.1.3

* Thu Jun 8 2017 Daniel Berteaud <daniel@firewall-services.com> 0.2.62-1
- Slightly reduce spamassassin BL scores

* Mon Jun 5 2017 Daniel Berteaud <daniel@firewall-services.com> 0.2.61-1
- Add some blacklists to spamassassin

* Thu Apr 6 2017 Daniel Berteaud <daniel@firewall-services.com> 0.2.60-1
- Add support for separated __VILLE__ __RUE__ and __CODE_POSTAL__ tags
  for email signature

* Wed Mar 8 2017 Daniel Berteaud <daniel@firewall-services.com> 0.2.59-1
- Make sure bayes auto learn is disabled when not enabled
- Adjust default bayes auto learn threshold

* Wed Nov 9 2016 Daniel Berteaud <daniel@firewall-services.com> 0.2.58-1
- Enable access to /server-status for localhost

* Wed May 18 2016 Daniel Berteaud <daniel@firewall-services.com> 0.2.57-1
- Remove MailSpike BL

* Fri May 13 2016 Daniel Berteaud <daniel@firewall-services.com> 0.2.56-1
- Fix a syntax error in spamassassin conf template

* Wed Apr 13 2016 Daniel Berteaud <daniel@firewall-services.com> 0.2.55-1
- Remove S-A custom scores
- Add MailSpike BL
- Requires smeserver-expire-accounts
- Add spamassassin autolearn param

* Wed Dec 23 2015 Daniel Berteaud <daniel@firewall-services.com> 0.2.54-1
- Fix home RecycleBin purge by using mtime instead of atime

* Fri Dec 4 2015 Daniel Berteaud <daniel@firewall-services.com> 0.2.53-1
- Define netfs service in the DB

* Wed Dec 2 2015 Daniel Berteaud <daniel@firewall-services.com> 0.2.52-1
- Fix /var/clamav ownership

* Fri Nov 27 2015 Daniel Berteaud <daniel@firewall-services.com> 0.2.51-1
- Ignore winnow.spam.ts.brokenspam.1 virus

* Fri Aug 7 2015 Daniel Berteaud <daniel@firewall-services.com> 0.2.50-1
- Requires recent enough yum instead of yum-downloadonly

* Mon Jul 6 2015 Daniel Berteaud <daniel@firewall-services.com> 0.2.49-1
- Remove hardcoded value for open_files_limit
- Set the default open_files_limit to 8192

* Mon Feb 9 2015 Daniel Berteaud <daniel@firewall-services.com> 0.2.48-1
- Add a EmailPrimaryDomain prop to user account

* Fri Jan 30 2015 Daniel Berteaud <daniel@firewall-services.com> 0.2.47-1
- Download updates even when a dependencie issue would prevent the
  transaction

* Mon Jun 30 2014 Daniel Berteaud <daniel@firewall-services.com> 0.2.46-1
- Replace header_access directive with request_header_access

* Mon Jun 23 2014 Daniel Berteaud <daniel@firewall-services.com> 0.2.45-1
- Replace syslog templates-custom with rsyslog fragment

* Fri Mar 21 2014 Daniel Berteaud <daniel@firewall-services.com> 0.2.44-1
- Fix AllowedRemoteIP (SPF Whitelist)

* Wed Mar 12 2014 Daniel Berteaud <daniel@firewall-services.com> 0.2.43-1
- Add SPF support (qpsmtpd and tinydns)

* Fri Jan 24 2014 Daniel Berteaud <daniel@firewall-services.com> 0.2.42-1
- Add a simple audit page in userinfo panel

* Mon Jan 20 2014 Daniel Berteaud <daniel@firewall-services.com> 0.2.41-1
- Update email address in LDAP if the first one in the list has changed

* Wed Dec 11 2013 Daniel Berteaud <daniel@firewall-services.com> 0.2.40-1
- Remove the non templated qmail-notify cron file

* Wed Dec 11 2013 Daniel Berteaud <daniel@firewall-services.com> 0.2.39-1
- Really fix qmail-notify cron

* Wed Dec 11 2013 Daniel Berteaud <daniel@firewall-services.com> 0.2.38-1
- Fix qmail-notify cron

* Tue Nov 12 2013 Daniel Berteaud <daniel@firewall-services.com> 0.2.37-1
- New branch for SME9

* Fri Nov 8 2013 Daniel Berteaud <daniel@firewall-services.com> 0.2.36-1
- Allow placeholders in signatures templates to be removed if the
  corresponding value is empty
- Strip http:// or https at the begining and / at the end of the Url
  prop in the signature

* Tue Oct 15 2013 Daniel Berteaud <daniel@firewall-services.com> 0.2.35-1
- Remove phpmailer from the potential spam mailers
- Reduce scrore for FSL_HELO_FIREWALL

* Fri Sep 27 2013 Daniel Berteaud <daniel@firewall-services.com> 0.2.34-1
- Reduce score for KHOP_BIG_TO_CC to 1.5
- Fix a warning in purge-home-recycle script

* Thu Sep 26 2013 Daniel Berteaud <daniel@firewall-services.com> 0.2.33-1
- Reduce a few spamassassin score, which were too agressive

* Wed Sep 25 2013 Daniel Berteaud <daniel@firewall-services.com> 0.2.32-1
- Fix the purge-home-recycle script

* Tue Sep 17 2013 Daniel Berteaud <daniel@firewall-services.com> 0.2.31-1
- Other spamassassin scores adjustments

* Thu Jun 13 2013 Daniel Berteaud <daniel@firewall-services.com> 0.2.30-1
- Disable default samba logging

* Thu Jun 6 2013 Daniel Berteaud <daniel@firewall-services.com> 0.2.29-1
- Set default pyzor timeout to 15 sec
- Add some spamassassin rules to fight against spam in french
- Adjust some spamassassin scores
- Fix another syntax erreor in share-modify-scan script

* Wed Jun 5 2013 Daniel Berteaud <daniel@firewall-services.com> 0.2.28-1
- Replace denyhosts with fail2ban
- Obsoletes smeserver-mailstats

* Fri Apr 19 2013 Daniel Berteaud <daniel@firewall-services.com> 0.2.27-1
- add innodb_file_per_table directive to my.cnf

* Fri Apr 19 2013 Daniel Berteaud <daniel@firewall-services.com> 0.2.26-1
- Allow up to 500 connections to MySQL

* Fri Dec 21 2012 Daniel Berteaud <daniel@firewall-services.com> 0.2.25-1
- Fix updates download cron job

* Mon Dec 3 2012 Daniel Berteaud <daniel@firewall-services.com> 0.2.24-1
- Some scan require read permissions on directories

* Wed Nov 28 2012 Daniel Berteaud <daniel@firewall-services.com> 0.2.23-1
- Download available updates nightly

* Tue Nov 20 2012 Daniel Berteaud <daniel@firewall-services.com> 0.2.22-1
- More fixes for scan ACLs

* Mon Nov 19 2012 Daniel Berteaud <daniel@firewall-services.com> 0.2.21-1
- Fix a typo in share-modify-scan script

* Thu Nov 15 2012 Daniel Berteaud <daniel@firewall-services.com> 0.2.20-1
- Fix default ACL for admins group in scan share

* Thu Nov 15 2012 Daniel Berteaud <daniel@firewall-services.com> 0.2.19-1
- Several fixes in scan share ACL

* Fri Sep 28 2012 Daniel Berteaud <daniel@firewall-services.com> 0.2.18-1
- Add SRV records for imap, imaps, smtp and smtps services

* Fri Sep 28 2012 Daniel Berteaud <daniel@firewall-services.com> 0.2.17-1
- add make-srv script to generate SRV records in tinydns

* Mon Sep 10 2012 Daniel Berteaud <daniel@firewall-services.com> 0.2.16-1
- Validation for the shell field
- accept empty value for the shell and the chroot dir
- add a script to purge home dir recycle bin

* Fri Aug 24 2012 Daniel Berteaud <daniel@firewall-services.com> 0.2.15-1
- Add a chroot field in user info panel

* Tue Jul 17 2012 Daniel Berteaud <daniel@firewall-services.com> 0.2.14-1
- Keep last 50 log files for mail services instead of 10

* Tue Jun 26 2012 Daniel Berteaud <daniel@firewall-services.com> 0.2.13-1
- Fix group mail addresses in viewgroup userpanel

* Sun Jun 24 2012 Daniel Berteaud <daniel@firewall-services.com> 0.2.12-1
- Move generated signatures in tools share

* Sun Jun 17 2012 Daniel Berteaud <daniel@firewall-services.com> 0.2.11-1
- Copy cacert in Primary ibay

* Fri Jun 8 2012 Daniel Berteaud <daniel@firewall-services.com> 0.2.10-1.sme
- Copy cacrl in Primary ibay

* Tue May 29 2012 Daniel Berteaud <daniel@firewall-services.com> 0.2.9-1.sme
- Update private cacert

* Thu May 24 2012 Daniel Berteaud <daniel@firewall-services.com> 0.2.8-1.sme
- Use pbzip2 instead of bzip2 for maillog rotation

* Wed May 23 2012 Daniel Berteaud <daniel@firewall-services.com> 0.2.7-1.sme
- Include CHANGELOG

* Fri May 18 2012 Daniel Berteaud <daniel@firewall-services.com> 0.2.6-1.sme
- Optimizations in LDAP updates scripts

* Tue Apr 24 2012 Daniel Berteaud <daniel@firewall-services.com> 0.2.5-1.sme
- Kill qpsmtpd after 1h instead of 30min

* Mon Apr 16 2012 Daniel Berteaud <daniel@firewall-services.com> 0.2.4-1.sme
- Revert previous commit, havp is now in front of squid

* Mon Apr 16 2012 Daniel Berteaud <daniel@firewall-services.com> 0.2.3-1.sme
- Don't hide X_Forwarded_For headers in squid if havp is enabled

* Fri Apr 13 2012 Daniel Berteaud <daniel@firewall-services.com> 0.2.2-1.sme
- Revert previous commit, bootstrap.min.css will go in webapps

* Thu Apr 12 2012 Daniel Berteaud <daniel@firewall-services.com> 0.2.1-1.sme
- Add bootstrap.min.css

* Tue Apr 03 2012 Daniel Berteaud <daniel@firewall-services.com> 0.2.0-1.sme
- Switch to git
- Fix PATH in cron script
- Initialize PasswordSet, AllowRSSH and VPNClientAccess prop for special accounts

* Sun Mar 04 2012 Daniel Berteaud <daniel@firewall-services.com> 0.1-24.sme
- Fix cron scripts permissions
- Add scan share with required permissions for scan2file (smb)
- Fix private cacert script
- Work arround a bug with spam score in some locales
- Add greylisting support in qpsmtpd

* Thu Mar 01 2012 Daniel Berteaud <daniel@firewall-services.com> 0.1-23.sme
- Rise MySQL open_files_limit to 4096

* Thu Dec 01 2011 Daniel Berteaud <daniel@firewall-services.com> 0.1-22.sme
- Monthly archive maillog's Maildir (if qpsmtpd->ArchiveBcc is enabled)
- Add a new url attribute (not in LDAP, only for signature __URL__)
- Requires openssl-perl
- Stop running navigation-conf in ipasserelle-update
- Chown signature dir to the user
- Use larger fields in panel

* Fri Oct 28 2011 Daniel Berteaud <daniel@firewall-services.com> 0.1-20.sme
- Add a custom template (no other choice) to send samba audit log to a separate file

* Thu Jul 21 2011 Daniel Berteaud <daniel@firewall-services.com> 0.1-19.sme
- Remove LL::NG dep and all portal related stuff
- Separate tel and mob in signature generation script
- Add all functions variable in email signature generation script
- Kill stalled qpsmtpd process to prevent reaching instance limit
- Allow to choose email signature template per user (SignatureTemplate)
- Rename tag __SECTEUR__ to __SERVICE__ for the signature

* Wed Jul 13 2011 Daniel Berteaud <daniel@firewall-services.com> 0.1-18.sme
- Remove defaults example vhost and categories from LL::NG conf
- LL::NG Self protect the manager

* Fri Jul 08 2011 Daniel Berteaud <daniel@firewall-services.com> 0.1-17.sme
- Generate both txt and html version of the signature

* Fri Jul 08 2011 Daniel Berteaud <daniel@firewall-services.com> 0.1-16.sme
- Fix tel tag in signature

* Thu Jul 07 2011 Daniel Berteaud <daniel@firewall-services.com> 0.1-15.sme
- Disable weekly raid checks
- Add a basic email signature generator
- Fix a small typo in userinfo fr locale
- requires iftop

* Mon Jul 04 2011 Daniel Berteaud <daniel@firewall-services.com> 0.1-14.sme
- Depend on LL::NG and add / change some default config to match what
  is expected on iPasserelle

* Tue Jun 28 2011 Daniel Berteaud <daniel@firewall-services.com> 0.1-13.sme
- Fix a typo in group-modify event

* Mon Jun 20 2011 Daniel Berteaud <daniel@firewall-services.com> 0.1-12.sme
- Add support for qmail-notify

* Sun Jun 19 2011 Daniel Berteaud <daniel@firewall-services.com> 0.1-11.sme
- Add PreferredMail as the first mail attribute in LDAP
- Fix copyright header

* Sat Jun 18 2011 Daniel Berteaud <daniel@firewall-services.com> 0.1-10.sme
- Add alternative Email addresses in userinfo panel

* Wed May 11 2011 Daniel Berteaud <daniel@firewall-services.com> 0.1-9.sme
- Don't let Squid send XForwardedFor headers
- Don't cache yum repo data with squid

* Tue May 10 2011 Daniel Berteaud <daniel@firewall-services.com> 0.1-8.sme
- Fix a typo in the tools share ReadGroup prop

* Wed Apr 06 2011 Daniel Berteaud <daniel@firewall-services.com> 0.1-7.sme
- Display group alias in viewgroups panel

* Tue Apr 05 2011 Daniel Berteaud <daniel@firewall-services.com> 0.1-6.sme
- Add userpanel-viewgroups

* Mon Apr 04 2011 Daniel Berteaud <daniel@firewall-services.com> 0.1-5.sme
- Re-create userpanels symlinks in ipasserelle-update

* Thu Mar 17 2011 Daniel Berteaud <daniel@firewall-services.com> 0.1-4.sme
- Add desktopLoginShell LDAP attr
- Allow empty preferred mail

* Mon Mar 14 2011 Daniel Berteaud <daniel@firewall-services.com> 0.1-3.sme
- Add autofs and ipmi service entries in the DB
- Add postalCode LDAP attribute
- Add validation routine for some fields

* Tue Mar 8 2011 Daniel Berteaud <daniel@firewall-services.com> 0.1-2.sme
- Add extensionNumber LDAP attribute

* Thu Jan 20 2011 Daniel Berteaud <daniel@firewall-services.com> 0.1-1.sme
- initial release


%prep
%setup -q -n %{name}-%{version}

%build
%{__mkdir_p} root/home/e-smith/files/shares/tools/files/signatures/templates
%{__mkdir_p} root/home/e-smith/files/scan
%{__mkdir_p} root/var/lib/qpsmtpd/greylisting
perl createlinks

%install
/bin/rm -rf $RPM_BUILD_ROOT
(cd root   ; /usr/bin/find . -depth -print | /bin/cpio -dump $RPM_BUILD_ROOT)
/bin/rm -f %{name}-%{version}-filelist
/sbin/e-smith/genfilelist $RPM_BUILD_ROOT \
   --file /etc/cron.hourly/qpsmtpd-cleanup 'attr(0755,root,root)' \
   --file /etc/cron.monthly/maillog-rotate 'attr(0755,root,root)' \
   --file /etc/cron.hourly/cacrl 'attr(0755,root,root)' \
   --file /etc/cron.daily/purge-homes-recycle 'attr(0755,root,root)' \
   --file /etc/cron.daily/download-updates 'attr(0755,root,root)' \
   --dir /home/e-smith/files/scan 'attr(0750,root,shared)' \
   --dir /var/lib/qpsmtpd/greylisting 'attr(0750,qpsmtpd,qpsmtpd)' \
   --file /usr/bin/make-srv 'attr(0755,root,root)' \
   --dir /var/clamav 'attr(0755,clamav,clamav)' \
  > %{name}-%{version}-filelist
echo "%doc" >> %{name}-%{version}-filelist

%files -f %{name}-%{version}-filelist
%defattr(-,root,root)

%clean
rm -rf $RPM_BUILD_ROOT

%post

%preun


